
;;; Now for Turtle Graphics:
;;;
;;;	The turtle runs on a co-ordinate system ranging from (-1,-1) on the lower left
;;; to (1,1) on the upper rigtht.  Available commands are as follows:
;;;
;;; (left angle), (right angle) -- turn turtle by <angle> radians left/right
;;; (forward dist)              -- move turtle forward by <dist> (backward if negative)
;;; (pen-up)/(pen-down)         -- set turtle to not draw/draw its trail
;;; (reset-turtle! x y head)    -- initialize turtle to be at (x,y) heading <head>,
;;;                             --  with pen down (i.e., drawing)
;;; (clear-graphics)            -- as usual, this will clear the screen
;;;
;;; The implementation here uses move-to! and line-to! primitives, and (clear-graphics).

(define *heading* 0)
(define *place-x* 0)
(define *place-y* 0)
(define *pen-drawing* 1)

(define (reset-turtle! x y heading)
  (set! *heading* heading)
  (set! *place-x* x)
  (set! *place-y* y)
  (set! *pen-drawing* 1)
  'done)

(define (left angle)
  (set! *heading* (+ *heading* angle))
  'done)

(define (right angle)
  (left (- angle)))

(define (pen-up)
  (set! *pen-drawing* 0))

(define (pen-down)
  (set! *pen-drawing* 1))

(define (forward length)
  (move-to! *place-x* *place-y*)
  (let ((new-x (+ *place-x* (* length (cos *heading*))))
        (new-y (+ *place-y* (* length (sin *heading*)))))
    ((if (zero? *pen-drawing*) move-to! line-to!)
     new-x new-y)
    (set! *place-x* new-x)
    (set! *place-y* new-y)
    'done))
