
;;;
;;; Low-level routines to implement graphics in Chipmunk Scheme.
;;;
;;; This gives a graphics window that is 512x390 and has a very primitive
;;; interface.  In this code, we simply map the graphics primitives used in our
;;; code to the position-pen and draw-line-to commands of the Chipmunks.
;;;
;;; The problem set graphics uses an abstract coordinate system in which the
;;; bottom left of the screen is at (-1, -1) and the top right at (1, 1), with
;;; (0, 0), the origin, at the center.  The graphics primitives in terms of
;;; these coordinates are:
;;; clear-graphics	-- erases the graphics screen
;;; (move-to! x y) -- positions the pen at (x, y)
;;; (line-to! x y) -- draws a line from the current position to (x, y)

;;; We define the graphics screen's parameters:

(define *screen-top* 194)
(define *screen-bot* -195)
(define *screen-left* -195)
(define *screen-right* 194)

(define *virt-top* 1)
(define *virt-bot* -1)
(define *virt-left* -1)
(define *virt-right* 1)

(define *x-scale* (/ (- *screen-right* *screen-left*)
                     (- *virt-right* *virt-left*)))

(define *y-scale* (/ (- *screen-top* *screen-bot*)
                     (- *virt-top* *virt-bot*)))

(define (screen-scale point pmin scale min)
  (+ min (round (* (- point pmin) scale))))

(define (draw-prim proc x y)
  (proc (screen-scale x *virt-left* *x-scale* *screen-left*)
        (screen-scale y *virt-bot* *y-scale* *screen-bot*)))

(define (move-to! x y)
  (draw-prim position-pen x y))

(define (line-to! x y)
  (draw-prim draw-line-to x y))

;; clear-graphics is already defined in MacScheme, appropriately.
