;;; Pictures are defined as procedures that take rectangles and draw
;;; themselves in the rectangles.

(define (superpose picture-1 picture-2)
  (lambda (rect)
    (append (picture-1 rect)
	    (picture-2 rect))))


(define (rotate picture angle)
  (lambda (rect)
    (picture (rotated rect angle))))

(define (scale picture factor)
  (lambda (rect)
    (picture (scaled rect factor))))

(define (translate picture x y)
  (lambda (rect)
    (picture (translated rect x y))))


;;; Primitive pictures makes a list of line segments.
 
(define (line rect)
  (list (draw-line rect -1 0 1 0)))

(define (half-line rect)
  (list (draw-line rect -.5 0 .5 0)))

;;; Operations on rectangles:

(define (rotated rect angle)
  (make-rect (origin rect)				
             (rotate-vect (horiz rect) angle)
             (rotate-vect (vert rect) angle)))

(define (translated rect x y)
  (make-rect (+vect (origin rect)
                    (+vect (scale-vect (horiz rect) x)
                           (scale-vect (vert rect) y)))
                  (horiz rect)
                  (vert rect)))

(define (scaled rect factor)
  (make-rect (origin rect)
             (scale-vect (horiz rect) factor)
             (scale-vect (vert rect) factor)))
