(define mit-rules
  (list
    (make-rule '(((? person) is an MIT student))     ; list of antecedents
               '((? person) is a hacker)             ; consequent
               '(local universality of hackerhood))  ; rule-name

    (make-rule '(((? x) is a hacker)                 ; two antecedents
                 ((? x) hacks computers))
               '((? x) likes chinese food)
               '(de gustibus))))






(define genesis-facts
  '((terach is father of abraham)
    (sarah is mother of isaac)
    (abraham is father of isaac)
    (abraham is father of ishmael)
    (isaac is father of essau)
    (isaac is father of jacob)
    (ishmael is father of hadad)))

(define genesis-rules
  (list 
   (make-rule '(((? f) is father of (? c)))
	      '((? c) is child of (? f))
	      '(invert father))

   (make-rule '(((? m) is mother of (? c)))
	      '((? c) is child of (? m))
	      '(invert mother))

   (make-rule '(((? c) is child of (? p)))
	      '((? p) is ancestor of (? c))
	      '(immediate ancestry))

   (make-rule '(((? a) is ancestor of (? b))
		((? b) is ancestor of (? c)))
	      '((? a) is ancestor of (? c))
	      '(transitivity of ancestry))
   ))


(define the-sentential-rules
  (list (make-rule '( (? a)
		      (implies (? a) (? b)) )
		   '(? b)
		   '(Modus ponendo ponens))
    
	(make-rule '( (implies (? a) (? b))
		      (not (? b)) )
		   '(not (? a))
		   '(Modus tollendo tollens 1))
    
	(make-rule '( (implies (? a) (not (? b)))
		      (? b) )
		   '(not (? a))
		   '(Modus tollendo tollens 2))
    
	(make-rule '( (or (? a) (? b))
		      (not (? a)) )
		   '(? b)
		   '(Modus tollendo ponens 1))
    
	(make-rule '( (or (? a) (? b))
		      (not (? b)) )
		   '(? a)
		   '(Modus tollendo ponens 2))
    
	(make-rule '( (not (not (? a))) )
		   '(? a)
		   '(Double negation elimination))
    
	(make-rule '( (or (not (? a)) (? b)) )
		   '(implies (? a) (? b))
		   '(Definition of implication 1))
    
    
	(make-rule '( (or (? b) (not (? a))) )
		   '(implies (? a) (? b))
		   '(Definition of implication 2))
    
	(make-rule '( (implies (? a) (? b))
		      (implies (? b) (? c)) )
		   '(implies (? a) (? c))
		   '(Transitivity of implication))
    
	(make-rule '( (implies (? a)
			       (implies (? b)
					(? c))) )
		   '(implies (? b)
			     (implies (? a)
				      (? c)))
		   '(Interchange of antecedents))
    
    
	)
  )

;;;   From Suppes, Introduction to Logic, p25.
;;;  
;;;  Example 1:  If there are no government subsides of agriculture, then
;;;  there are government controls of agriculture.  If there are government
;;;  controls of agriculture, there is not an agricultural depression.
;;;  There is either an agricultural depression or overproduction.  As a
;;;  matter of fact, there is no overproduction.  Therefore, there are
;;;  government subsidies of agriculture.



(define example-1
  '(((implies (not (there are government subsidies of agriculture))
              (there are government controls of agriculture))
     (implies (there are government controls of agriculture)
              (not (there is an agricultural depression)))
     (or (there is an agricultural depression)
         (there is overproduction))
     (not (there is overproduction)))
    
    (there are government subsidies of agriculture)))



;;;   From Suppes, Introduction to Logic, p29.

;;;  Example 2: (The National League Race).  If the Cards are third, then
;;;  if the Dodgers are second the Braves will be fourth.  Either the
;;;  Giants will not be first or the Cards will be third.  In fact the
;;;  Dodgers will be second.  Therefore, if the Giants are first, then the
;;;  Braves will be fourth.



(define example-2
  '(((implies (Cards are third)
              (implies (Dodgers are second)
                       (Braves are fourth)))
     (or (not (Giants are first))
         (Cards are third))
     (Dodgers are second))
    
    (implies (Giants are first)
             (Braves are fourth))))
