;;; -*- Scheme -*- PS9-FREE.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Spring Semester, 1991
;;
;;				 Problem Set 9

(define *free-variables*)
(define *fake-frame*)

(define (compile expression)
  (set! *free-variables* '())
  (set! *fake-frame* (list (make-new-symbol '*fake-frame*)))
  (let ((result
	 (compile-expression expression
			     (list *fake-frame*)
			     'val
			     'return)))
    (statements
     (if (null? *free-variables*)
	 result
	 (append-instruction-sequences
	  (make-register-assignment 'argl (make-constant '()))
	  (cache-free-variables
	   (reverse *free-variables*)
	   result))))))

(define (cache-free-variables variables code)
  (if (null? variables)
      (append-instruction-sequences
       (make-register-assignment
	'env
	(make-operation 'adjoin-frame
			(make-fetch 'argl)
			(make-fetch 'env)))
       code)
      (preserving
       'env
       (preserving
	'argl
	(cache-a-free-variable (car variables))
	(make-register-assignment
	 'argl
	 (make-operation 'cons
			 (make-fetch 'arg0)
			 (make-fetch 'argl))))
       (cache-free-variables (cdr variables)
			     code))))

(define (cache-a-free-variable name)
  (let ((label (make-new-label 'after-lookup)))
    (append-instruction-sequences
     (make-register-assignment 'continue label)
     (make-register-assignment 'exp (make-constant name))
     (make-instruction
      (make-set '(exp env))
      (make-set '(env arg0 arg1 arg2 arg3))
      (list 'goto 'get-variable-binding/define))
     (make-entry-point-designator label))))      

(define (find-free-variable! name c-t-env)
  (define (find-or-bind names offset)
    (cond ((null? names)
	   (set! *free-variables*
		 (append *free-variables*
			 (list name)))
	   offset)
	  ((eq? name (car names))
	   offset)
	  (else
	   (find-or-bind (cdr names) (1+ offset)))))

  (if (not (memq *fake-frame* c-t-env))
      (error "find-free-variable: Fake frame disappeared!" c-t-env)
      (let ((offset (find-or-bind *free-variables* 0)))
	(make-lexical-address (-1+ (length c-t-env))
			      offset))))

(define (compile-unknown-variable name c-t-env target)
  (let ((lexical-address (find-free-variable! name c-t-env))
	(reg-target
	 (if (null? target)
	     'arg0
	     target)))
    (append-instruction-sequences
     (make-get-lexically-addressed-binding lexical-address)
     (make-register-assignment reg-target
			       (make-operation 'binding-value
					       (make-fetch 'arg0)))
     (make-branch (make-operation 'eq?
				  (make-fetch reg-target)
				  (make-constant '*UNASSIGNED*))
		  (make-label 'signal-error)))))

(define (make-variable-definition var c-t-env value)
  (define (do-it env-reg)
    (make-perform
     (make-operation 'define-variable!
		     (make-constant var)
		     value
		     (make-fetch env-reg))))

  (cond ((null? c-t-env)
	 (error "make-variable-definition: Null environment model"))
	((not (eq? (car c-t-env) *fake-frame*))
	 (do-it 'env))
	(else
	 (append-instruction-sequences
	  (make-register-assignment 'arg0
				    (make-operation 'cdr
						    (make-fetch 'env)))
	  (do-it 'arg0)))))