;;; -*- Scheme -*- PS9-SCAN.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Spring Semester, 1991
;;
;;				 Problem Set 9


(define (compile-lambda-body exp c-t-env proc-entry)
  (append-instruction-sequences
   (make-entry-point-designator proc-entry)
   (make-environment-switch (lambda-parameters exp))
   (compile-sequence
    (scan-out-defines (lambda-body exp))
    (extend-compile-time-env (lambda-parameters exp) c-t-env)
    'val
    'return)))

(define (scan-out-defines lambda-body)
  (define (collect-definitions body names assignments)
    (cond ((null? body)
	   (error "scan-out-defines: Body contains only definitions"
		  lambda-body))
	  ((definition? (car body))
	   (let ((name (definition-variable (car body)))
		 (value (definition-value (car body))))
	     (collect-definitions (cdr body)
				  (cons name names)
				  (cons (list 'set! name value)
					assignments))))
	  (else
	   (cons (reverse names)
		 (append (reverse assignments)
			 body)))))
  (let ((result (collect-definitions lambda-body '() '())))
    (if (null? (car result))
	(cdr result)
	(list
	 (cons 'let
	       (cons
		(mapcar (lambda (name)
			  (list name ''*unassigned*))
			(car result))
		(cdr result)))))))
		    
