;;; -*- Scheme -*- PS9-SYNTAX.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Spring Semester, 1991
;;
;;				 Problem Set 9

;;;; Syntax for simulation of explicit-control evaluator

;;; represent expressions -- from 4.1.2

(define (self-evaluating? exp) (number? exp))

(define (quoted? exp)
  (if (atom? exp)
      nil
      (eq? (car exp) 'quote)))

(define (text-of-quotation exp) (cadr exp))

(define (variable? exp) (symbol? exp))

(define (assignment? exp)
  (if (atom? exp)
      nil
      (eq? (car exp) 'set!)))

(define (assignment-variable exp) (cadr exp))

(define (assignment-value exp) (caddr exp))

(define (definition? exp)
  (if (atom? exp)
      nil
      (eq? (car exp) 'define)))

(define (definition-variable exp)
  (if (variable? (cadr exp))
      (cadr exp)
      (caadr exp)))

(define (definition-value exp) 
  (if (variable? (cadr exp))
      (caddr exp)
      (cons 'lambda
	    (cons (cdadr exp)    
		  (cddr exp)))))

(define (lambda? exp)
  (if (atom? exp)
      nil
      (eq? (car exp) 'lambda)))

(define (lambda-parameters exp) (cadr exp))

(define (lambda-body exp) (cddr exp))


(define (conditional? exp)
  (if (atom? exp)
      nil
      (eq? (car exp) 'cond)))

(define (clauses exp) (cdr exp))

(define (no-clauses? clauses) (null? clauses))

(define (first-clause clauses) (car clauses))

(define (rest-clauses clauses) (cdr clauses))

(define (predicate clause) (car clause))

(define (actions clause) (cdr clause))

(define (true? x) (not (null? x)))

(define (else-clause? clause)
  (eq? (predicate clause) 'else))

(define (last-exp? seq) (null? (cdr seq)))

(define (first-exp seq) (car seq))

(define (rest-exps seq) (cdr seq))


;;;no-args? added and application? changed (from 5.2.1)

(define (no-args? exp)
  (if (atom? exp)
      nil
      (null? (cdr exp))))

(define (application? exp)
  (if (atom? exp)
      nil
      (not (null? (cdr exp)))))

(define (operator app) (car app))

(define (operands app) (cdr app))


;;;last-operand? added -- from 5.2.1

(define (last-operand? args)
  (null? (cdr args)))

(define (no-operands? args) (null? args))

(define (first-operand args) (car args))

(define (rest-operands args) (cdr args))

(define (make-procedure lambda-exp env)
  (list 'procedure lambda-exp env))

(define (compound-procedure? proc)
  (if (atom? proc)
      nil
      (eq? (car proc) 'procedure)))

(define (parameters proc) (cadr (cadr proc)))

(define (procedure-body proc) (cddr (cadr proc)))

(define (procedure-environment proc) (caddr proc))


;;;operations on environments -- from 4.1.3

(define (lookup-variable-value var env)
  (let ((b (binding-in-env var env)))
    (if (found-binding? b)
        (binding-value b)
        (error "Unbound variable" var))))

(define (binding-in-env var env)
  (if (no-more-frames? env)
      no-binding
      (let ((b (binding-in-frame var (first-frame env))))
        (if (found-binding? b)
            b
            (binding-in-env var (rest-frames env))))))

(define (extend-environment variables values base-env)
  (adjoin-frame (make-frame variables values) base-env))

(define (set-variable-value! var val env)
  (let ((b (binding-in-env var env)))
    (if (found-binding? b)
        (set-binding-value! b val)
        (error "Unbound variable" var))))

(define (define-variable! var val env)
  (let ((b (binding-in-frame var (first-frame env))))
    (if (found-binding? b)
        (set-binding-value! b val)
	(set-first-frame!
	 env
	 (adjoin-binding (make-binding var val)
			 (first-frame env))))))


;;;representing environments -- from 4.1.3

(define (first-frame env) (car env))

(define (rest-frames env) (cdr env))

(define (no-more-frames? env) (null? env))

(define (adjoin-frame frame env) (cons frame env))

(define (set-first-frame! env new-frame)
  (set-car! env new-frame))


;;;representing frames -- from 4.1.3

(define (make-frame variables values)
  (cond ((and (null? variables) (null? values)) '())
        ((null? variables)
         (error "Too many values supplied" values))
        ((null? values)
         (error "Too few values supplied" variables))
        (else
         (cons (make-binding (car variables)
                             (car values))
               (make-frame (cdr variables)
                           (cdr values))))))

(define (adjoin-binding binding frame)
  (append frame (list binding)))	; APH

(define (variable-assq key bindings)	; APH
  (cond ((null? bindings) no-binding)
        ((eq? key (binding-variable (car bindings))) (car bindings))
        (else (variable-assq key (cdr bindings)))))

(define (binding-in-frame var frame)
  (variable-assq var frame))		; APH

(define (found-binding? b)
  (not (eq? b no-binding)))

(define no-binding nil)


;;;representing bindings -- from 4.1.3

(define (make-binding variable value)
  (cons variable value))

(define (binding-variable binding)
  (car binding))

(define (binding-value binding)
  (cdr binding))

(define (set-binding-value! binding value)
  (set-cdr! binding value))

;;;;  Additions by APH

(define (if? exp)
  (if (pair? exp)
      (eq? (car exp) 'IF)
      false))

(define (if-exps exp)
  (cdr exp))

(define (if-pred exps)
  (car exps))

(define (if-conseq exps)
  (cadr exps))

(define (if-alter exps)
  (if (null? (cddr exps))
      '(quote nil)
      (caddr exps)))

(define (let? exp)
  (if (pair? exp)
      (eq? (car exp) 'LET)
      false))

(define (let-names exp)
  (mapcar car (cadr exp)))

(define (let-value-expressions exp)
  (mapcar cadr (cadr exp)))

(define (let-body exp)
  (cddr exp))

(define (sequence? exp)
  (if (pair? exp)
      (eq? (car exp) 'SEQUENCE)
      false))

(define (sequence-actions exp)
  (cdr exp))

(define (variable-expression? exp)
  (if (pair? exp)
      (eq? (car exp) 'VARIABLE)
      false))

(define (variable-expression-name exp)
  (cadr exp))