;;;;   PS1-SIN.SCM

;;;  This is a file of the code that appears in the problem-set
;;;   handout.  It is provided for your convenience and to save
;;;   you some typing.


(define (my-sine x)
  (if (small-enuf? x)
      x
      (poly (my-sine (/ x 3)))))

(define (poly x)
  (* x (- 3 (* 4 (square x)))))

(define (small-enuf? y)
  (< (abs y) epsilon))

(define (square x)
  (* x x))





(define (recurrent-sine x)
  (if (small-enough? x)
      (sine-approx x)
      (- (* k (recurrent-sine (- x w))) 
         (recurrent-sine (- x (* 2 w))))))

(define (small-enough? y)
  (<= (abs y) w))

(define k
  (* 2 (cos w)))





(define (sine-wave m a theta w)
  (define (iter n fn fn-1)
    (waveform-draw-to (/ n m) fn-1)
    (cond ((>= n m) 0)
          (else
	   (iter (1+ n) (poly fn fn-1) fn))))
  (define (poly x y)
    (- (* k x) y))
  (define k
    (* 2 (cos w)))
  (define initial-value
    (* a (sin theta)))
  (clear-waveform-graphics)
  (waveform-go-to 0 initial-value)
  (iter 0 
        (* a (sin (+ theta w))) 
        initial-value))



(define (lissajous npoints)
  (define (iter point)
    (lissajous-draw-to (x-coord point)
		       (y-coord point))
    (if (>= point npoints)
        0
        (iter (1+ point))))
  (clear-lissajous-graphics)
  (lissajous-go-to
   (x-coord 0)
   (y-coord 0))
  (iter 0)) 
 

(define (x-coord n)
  (* ampx (sin (+ (* fx w n) thetax))))

(define (y-coord n)
  (* ampy (sin (+ (* fy w n) thetay))))
