;;;;       SQUARE.SCM
;;; This is code for problem set 3.
;;;  It implements a Henderson-like
;;;  drawing language, based on squares.


;;; representing frames

(define make-frame list)

(define frame-origin car)
(define frame-side1 cadr)
(define frame-side2 caddr)

;;; a frame defines a map on points

(define (coord-map frame)
  (define (frame-map point)
    (vector-add
     (vector-add (vector-scale (vector-xcor point)
			       (frame-side1 frame))
		 (vector-scale (vector-ycor point)
			       (frame-side2 frame)))
     (frame-origin frame)))
  frame-map)


;;; Making a picture from a list of segments

(define make-segment cons)
(define segment-start car)
(define segment-end cdr)

(define (segments->drawing seglist)
  (define (drawing frame)
    (let ((m (coord-map frame)))
      (for-each
       (lambda (segment)
	 (drawline (m (segment-start segment))
		   (m (segment-end segment))))
       seglist)))
  drawing)


;;; Basic means of combination for drawings

(define (rotate90 drawing)
  (define (r90 frame)
    (drawing (make-frame
              (vector-add (frame-origin frame)
                          (frame-side1 frame))
              (frame-side2 frame)
              (vector-scale -1 (frame-side1 frame)))))
  r90)

(define rotate180 (repeated rotate90 2))
(define rotate270 (repeated rotate90 3))


(define (flip-horiz drawing)
  (define (flipped frame)
    (drawing (make-frame (vector-add (frame-origin frame)
				     (frame-side1 frame))
                         (vector-scale -1 (frame-side1 frame))
                         (frame-side2 frame))))
  flipped)

;;; correct

(define (beside drawing1 drawing2)
  (define (combo frame)
    (drawing1 (make-frame
               (frame-origin frame)
               (vector-scale .5 (frame-side1 frame))
               (frame-side2 frame)))
    (drawing2 (make-frame
               (vector-add (frame-origin frame)
                           (vector-scale .5
					 (frame-side1 frame)))
               (vector-scale .5 (frame-side1 frame))
               (frame-side2 frame))))
  combo)

;;; losing

(define (beside drawing1 drawing2)
  (define (combo frame)
    (drawing1 (make-frame
               (frame-origin frame)
               (vector-scale .5 (frame-side1 frame))
               (frame-side2 frame)))
    (drawing2 (make-frame
	       (vector-add (frame-origin frame)
                           (vector-scale .5
					 (frame-side1 frame)))
               (frame-side1 frame)
               (frame-side2 frame))))
  combo)

(define (below drawing1 drawing2)
  (rotate270 (beside (rotate90 drawing2)
                     (rotate90 drawing1))))

(define (superimpose drawing1 drawing2)
  (define (superposition frame)
    (drawing1 frame)
    (drawing2 frame))
  superposition)



;;; More complex means of combination

(define (right-split drawing n)
  (if (= n 1)
      drawing
      (let ((smaller (right-split drawing (- n 1))))
        (beside drawing (below smaller smaller)))))


;;; one other means of combination

(define (beside-squeezed pict1 pict2 ratio)
  (define (combo frame)
    (let ((p (vector-scale ratio (frame-side1 frame)))
	  (oa (frame-origin frame)))
      (pict1
       (make-frame oa p (frame-side2 frame)))
      (pict2
       (make-frame (vector-add p oa)
		   (vector-scale (- 1.0 ratio)
				 (frame-side1 frame))
		   (frame-side2 frame)))))
  combo)

;;; some simple drawings

(define empty-drawing (segments->drawing '()))

(define outline-drawing-segments
  (let ((v1 (make-vect 0 0))
	(v2 (make-vect 0 1))
	(v3 (make-vect 1 0))
	(v4 (make-vect 1 1)))
    (list (make-segment v1 v2)
	  (make-segment v2 v4)
	  (make-segment v4 v3)
	  (make-segment v3 v1))))

(define outline-drawing
  (segments->drawing outline-drawing-segments))

(define midpoints-segments
  (let ((center (make-vect (/ 1 3) (/ 1 3)))
	(m1 (make-vect (/ 1 2) 0))
	(m2 (make-vect 0 (/ 1 2)))
	(m3 (make-vect (/ 1 2) (/ 1 2))))
    (list (make-segment m1 center)
	  (make-segment m2 center)
	  (make-segment m3 center))))

(define midpoints 
  (segments->drawing midpoints-segments))


(define band-segments
  (let ((a1 (make-vect .4 0))
        (a2 (make-vect .6 0))
        (b1 (make-vect 0 .4))
        (b2 (make-vect 0 .6)))
    (list (make-segment a1 b1)
	  (make-segment a2 b2))))

(define band
  (segments->drawing band-segments))


(define v-shape-segments
  (let ((m1 (make-vect (/ 2 9) (/ 2 9)))
        (m2 (make-vect (/ 4 9) (/ 4 9)))
        (a1 (make-vect (/ 1 3) 0))
        (a2 (make-vect (/ 2 3) 0))
        (b1 (make-vect 0 (/ 1 3)))
        (b2 (make-vect 0 (/ 2 3))))
    (list (make-segment a1 m1)
	  (make-segment m1 b1)
	  (make-segment a2 m2)
	  (make-segment m2 b2))))

(define v-shape
  (segments->drawing v-shape-segments))

;;; drawing lines

(define *current-window*)

(define (draw window pict)
  (if (not (graphics-device? window))
      (error "Bad window" window))
  (graphics-clear window)
  (set! *current-window* window)
  (pict (screen-frame window)))

(define (screen-frame window)
  (with-values 
      (lambda ()
	(graphics-coordinate-limits window))
    (lambda (west south east north)
      (let ((screen-lower-left (make-vect west south))
	    (screen-lower-right (make-vect east south))
	    (screen-upper-left (make-vect west north)))
	(let ((screen-lower-edge
	       (vector-sub screen-lower-right screen-lower-left))
	      (screen-left-edge
	       (vector-sub screen-upper-left screen-lower-left)))
	  (make-frame screen-lower-left
		      screen-lower-edge
		      screen-left-edge))))))

(define (drawline start end)
  (graphics-draw-line *current-window*
		      (exact->inexact (vector-xcor start))
		      (exact->inexact (vector-ycor start))
		      (exact->inexact (vector-xcor end))
		      (exact->inexact (vector-ycor end))))
