;;; this is the file ps7-code.scm

;;; utility procedures

(define (head stream)
  (stream-first stream))

(define (tail stream)
  (stream-rest stream))

(define (map-2-streams proc stream1 stream2)
  (cons-stream (proc (head stream1)
                     (head stream2))
               (map-2-streams proc 
                              (tail stream1)
                              (tail stream2))))

(define (map-stream f x)
  (cons-stream (f (head x))
               (map-stream f (tail x))))

(define (print-stream s n)
  (define (loop k st)
    (cond ((= k 0) 'done)
          (else (newline)
		(display (head st)) 
                (loop (-1+ k) (tail st)))))
  (loop n s))

(define (square x)
  (* x x))

;;; archimedian-pi code

(define (refine-by-doubling s)
  (/ s (sqrt (+ 2 (sqrt (- 4 (* s s)))))))

(define (stream-of-iterates next value)
  (cons-stream value 
               (stream-of-iterates next (next value))))

(define side-lengths 
        (stream-of-iterates refine-by-doubling (sqrt 2)))

(define side-numbers
        (stream-of-iterates (lambda (n) (* 2 n)) 4))

(define (semi-perimeter length-of-side number-of-sides)
  (/ (* number-of-sides length-of-side) 2))

(define archimedian-pi-sequence
  (map-2-streams semi-perimeter side-lengths side-numbers))

(define side-lengths
  (cons-stream 
   (sqrt 2)
   (divide-streams 
    side-lengths
    (map-stream
     (lambda (x) (sqrt (+ 2 (sqrt (- 4 (square x))))))
     side-lengths))))

;;; Richardson extrapolation

(define (make-zeno-sequence r h)
  (cons-stream (r h) 
               (make-zeno-sequence r (/ h 2))))

(define (accelerate-zeno-sequence seq p)
  (let ((2**p (expt 2 p)))
    (let ((2**p-1 (- 2**p 1)))
      (map-2-streams (lambda (rh rh/2) (/ (- (* 2**p rh/2) rh) 2**p-1))
                     seq
                     (tail seq)))))

(define (make-zeno-tableau seq p q)
  (define (sequences seq order)
    (cons-stream seq
                 (sequences (accelerate-zeno-sequence seq order)
                            (+ order q))))
  (sequences seq p))

(define (richardson-sequence seq p q)
  (first-terms-of-zeno-tableau
   (make-zeno-tableau seq p q)))

;;; numerical integration

(define (sigma f a b)
  (define (loop n result)
    (if (> n b)
        result
        (loop (1+ n) (+ result (f n)))))
  (loop a 0))

(define (pi-integrand x) 
  (/ 4 (+ (square x) 1)))

;;; Romberg Integration

(define (romberg-sequence f a b)
  (richardson-sequence 
   (trapezoidal-sums f a b) 
   2
   2))

;;; for the optional problem

(define (deriv f)
  (lambda (x)
    (let ((h .001))
      (/ (- (f (+ x h)) (f (- x h)))
         2 h))))

(define (diff-quot-stream f x h)
  (cons-stream (/ (- (f (+ x h)) (f (- x h))) 2 h)
               (diff-quot-stream f x (/ h 2))))
