;;;    Copyright 1993, TQM Inc., the Inefficiency Experts.
;;;               All Rights Reserved
;;;    object-oriented technique -- patent applied for
;;;   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF TQM
;;;    The copyright notice above does not evidence any
;;;   actual or intended publication of such source code.



(define (send object message signature . args)
  (apply (object message) (cons signature args)))

(define make-place
  (lambda (name)
    (let ((occupants '()) (exits '()))
      (define (here message)
	(cond ((eq? message 'name?)
	       (lambda (who-asked) name))
	      ((eq? message 'who-is-here?)
	       (lambda (who) occupants))
	      ((eq? message 'exits?)
	       (lambda (who) exits))
	      ((eq? message 'new-exit)
	       (lambda (who new-exit)
		 (set! exits (cons new-exit exits))))
	      ((eq? message 'i-am-leaving)
	       (lambda (who)
		 (if (memq who occupants)
		     (set! occupants (delq who occupants))
		     (error "Ghostly departure" here who))
		 (write-line
		  (list (send who 'name? here) 'leaving name))
		 (for-each (lambda (occ)
			     (send occ 'departed here who))
			   occupants)))
	      ((eq? message 'i-am-arriving)
	       (lambda (who)
		 (if (memq who occupants)
		     (error "Already here" here who)
		     (set! occupants (cons who occupants)))
		 (write-line
		  (list (send who 'name? here) 'arriving name))
		 (for-each (lambda (occ)
			     (send occ 'arrived here who))
			   occupants)))
	      (else
	       (error "Unknown message -- PLACE"
		      message)))) 
      here)))

(define (make-person name place)
  (define (say-to-all message words except)
    (for-each (lambda (person)
		(newline)
		(for-each (lambda (string)
			    (display string)
			    (display " "))
			  (list name "says" words "to" (send person 'name? me)))
		(send person message me))
	      (list-difference (send place 'who-is-here? me) except)))
  (define (me message)
    (cond ((eq? message 'name?)
	   (lambda (who-asked) name))
	  ((eq? message 'go-to)
	   (lambda (sender new-place)
	     (say-to-all 'good-bye "good bye" (list me))
	     (send place 'i-am-leaving me)
	     (send new-place 'i-am-arriving me)
	     (set! place new-place)
	     (say-to-all 'hello "hello" (list me))
	     ))
	  ((eq? message 'hello)
	   (lambda (who)
	     ...))
	  ((eq? message 'good-bye)
	   (lambda (who)
	     ...))
	  ((eq? message 'arrived)
	   (lambda (place who-arrived)
	     ...))
	  ((eq? message 'departed)
	   (lambda (place who-departed)
	     ...))
	  (else
	   (error "Unknown message -- PERSON"
		  message))))
  (send place 'i-am-arriving me)
  (autonomous-agent!
   (lambda ()
     (let ((exits (send place 'exits? me)))
       (if (not (null? exits))
	   (send me 'go-to me (choose-from exits))))))
  me)

(define ... 'nothing-to-be-done)

(define (print-exits place)
  (newline)
  (for-each (lambda (other-place)
	      (display (send other-place 'name? place))
	      (display "  "))
	    (send place 'exits? 'user))
  'done)


(define (autonomous-agent! a)
  (set! *agents* (cons a *agents*)))

(define (choose-from l)
  (if (null? l)
      false
      (list-ref l (random (length l)))))

(define (list-difference l1 l2)
  (if (null? l2)
      l1
      (list-difference (delq (car l2) l1) (cdr l2))))

(define (list-union l1 l2)
  (cond ((null? l1) l2)
	((memq (car l1) l2)
	 (list-union (cdr l1) l2))
	(else
	 (cons (car l1)
	       (list-union (cdr l1) l2)))))

(define (delq x l)
  (cond ((null? l) l)
	((eq? x (car l)) (delq x (cdr l)))
	(else
	 (cons (car l) (delq x (cdr l))))))


;;; Serialized Simulation

(define (clock)
  (if (not (null? *agents*))
      ((choose-from *agents*)))
  (clock))

;;; Asynchronous Simulation      

(define stop 'not-started)

(define (run delta-t)
  (set! stop
	(apply parallel-execute
	       (map (lambda (agent)
		      (define (the-agent-process)
			(sleep-current-thread (random delta-t))
			(agent)
			(the-agent-process))
		      the-agent-process)
		    *agents*))))

#|
;;; One possible world.

(define *agents* '())

(define lecture (make-place "10-250"))

(define gjs-office (make-place "NE43-408"))
(define lou-office (make-place "36-747"))
(define bkph-office (make-place "NE43-715"))
(define fk-office (make-place "NE43-522"))
(define arm-office (make-place "NE43-315"))
(define jm-office (make-place "DEC CRL"))
(define gp-office (make-place "NE43-620"))
(define joe-office (make-place "NE43-210"))
(define psz-office (make-place "NE43-416"))

(send lecture 'new-exit 'physical-plant gjs-office)
(send lecture 'new-exit 'physical-plant lou-office)
(send lecture 'new-exit 'physical-plant bkph-office)
(send lecture 'new-exit 'physical-plant fk-office)
(send lecture 'new-exit 'physical-plant arm-office)
(send lecture 'new-exit 'physical-plant jm-office)
(send lecture 'new-exit 'physical-plant gp-office)
(send lecture 'new-exit 'physical-plant joe-office)
(send lecture 'new-exit 'physical-plant psz-office)

(send lou-office 'new-exit 'physical-plant lecture)
(send gjs-office 'new-exit 'physical-plant lecture)
(send bkph-office 'new-exit 'physical-plant lecture)
(send fk-office 'new-exit 'physical-plant lecture)
(send arm-office 'new-exit 'physical-plant lecture)
(send jm-office 'new-exit 'physical-plant lecture)
(send gp-office 'new-exit 'physical-plant lecture)
(send joe-office 'new-exit 'physical-plant lecture)
(send psz-office 'new-exit 'physical-plant lecture)

(send gjs-office 'new-exit 'physical-plant lou-office)

(define gjs (make-person "Gerald Jay Sussman" gjs-office))
(define lou (make-person "Louis D. Braida" lou-office))
(define bkph (make-person "Berthold K. P. Horn" bkph-office))
(define fk (make-person "Frans Kaashoek" fk-office))
(define arm (make-person "Albert Meyer" arm-office))
(define jm (make-person "Jim Miller" jm-office))
(define gp (make-person "Gill Pratt" gp-office))
(define joe (make-person "Joseph E. Stoy" joe-office))
(define psz (make-person "Peter Szolovits" psz-office))


;;;(clock)

;;;(run 10000)
;;;(stop)
|#
