(define (head x)
  (car x))

(define (tail x)
  (let ((d (cdr x)))
    (if (procedure? d)
	(let ((tl (mini-apply d '())))
	  (set-cdr! x tl)
	  tl)
	d)))

(define (tail x)
  (let ((d (cdr x)))
    (if (procedure? d)
	(let ((tl (mini-apply d '())))
	  ;;(set-cdr! x tl)
	  tl)
	d)))

(define (eval-cons-stream exp env)
  (mini-eval
   (list 'cons
	 (cadr exp)
	 (list 'lambda
	       '()
	       (caddr exp)))
   env))


(add-syntax! 'cons-stream eval-cons-stream)

(define primitive-procedure-names
  '(+ - * / = < > 1+ -1+ cons car cdr pair? eq? null? procedure? not
    user-write-line user-display user-load
    head tail))

#|
(define (map-2-streams proc s1 s2)
  (cons-stream (proc (head s1) (head s2))
	       (map-2-streams proc (tail s1) (tail s2))))


(define ones
  (cons-stream 1 ones))

(define natural-numbers
  (cons-stream 1
	       (map-2-streams +
			      ones
			      natural-numbers)))

(define factorials 
  (cons-stream 1
	       (map-2-streams *
			      natural-numbers
			      factorials)))

(define factorials 
  (cons-stream 1
	       (map-2-streams (lambda (x y) (user-display "*") (* x y))
			      natural-numbers
			      factorials)))

(define (stream-ref s n)
  (cond ((= n 0) (head s))
	(else (stream-ref (tail s) (- n 1)))))
|#
