;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../interface.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 13 09:09:53 1993                          */
;*    Last change :  Wed Sep 22 13:26:09 1993 (serrano)                */
;*                                                                     */
;*    L'interface avec les passes suivantes (lift)                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa_interface
   (include "Var/variable.sch"
	    "0cfa/0cfa.sch")
   (import  engine_param)
   (export  (add-to-strength-list! var)))

;*---------------------------------------------------------------------*/
;*    Les variables globales                                           */
;*---------------------------------------------------------------------*/
(define *strength-list* '())

;*---------------------------------------------------------------------*/
;*    add-to-strength-list! ...                                        */
;*---------------------------------------------------------------------*/
(define (add-to-strength-list! v)
   (if (and (local-E? v)
	    (memq (local-strength v) '(light extra-light)))
       (let* ((root (_lambda-root (local-info v)))
	      (cell (assq root *strength-list*)))
	  (if (not (pair? cell))
	      (set! *strength-list*
		    (cons `(,root ,(cons v (_lambda-strength (local-info v))))
			  *strength-list*))
	      (set-cdr! cell (cons `(,v . ,(_lambda-strength (local-info v)))
				   (cdr cell)))))))


