;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Cc/cc.scm ...            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul 15 09:29:05 1992                          */
;*    Last change :  Thu Nov 25 10:36:13 1993 (serrano)                */
;*                                                                     */
;*    On lance la compilation C                                        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cc_cc
   (include "Tools/trace.sch")
   (export  (cc name))
   (import  tools_speek
	    tools_file
	    engine_param))

;*---------------------------------------------------------------------*/
;*    cc ...                                                           */
;*---------------------------------------------------------------------*/
(define (cc name)
   (verbose "   . cc (" *cc* ")" #\Newline)
   (cond
      ((not (string? name))
       (error "cc" "can't process cc on stdout" name))
      (else
       (let ((cc-command (string-append *cc*
					" "
					*cc-options*
					" -c "
					" -I. -I" *include-dir*
					(if *c-debug*
					    (string-append " "
							   *c-debug-option*)
					    "")
					" " name ".c")))
	  (trace other "Je vais executer la commande: " #\Newline
		 cc-command #\Newline)
	  (let ((res (system cc-command)))
	     (if (not (=fx 0 res))
		 (error "c->o" "cc problem" res)
		 (let ((basename (basename name)))
		    (if (not (string=? basename name))
			(let* ((mv-command (string-append "/bin/mv "
							  basename
							  ".o "
							  name
							  ".o"))
			       (res        (system mv-command)))
			   (if (not (=fx 0 res))
			       (error "cc" "mv problem" res))))
		    (if *rm-c-files*
			(let* ((rm-command (string-append "/bin/rm "
							  name
							  ".c"))
			       (res        (system rm-command)))
			   (if (not (=fx 0 res))
			       (error "cc" "rm problem" res)))))))))))
		       
