;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.5b/Cse/cse.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 29 10:05:25 1993                          */
;*    Last change :  Mon Oct 25 17:28:31 1993 (serrano)                */
;*                                                                     */
;*    L'elimination des sous expressions communes                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cse_cse
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_speek
	    tools_error
	    type_type
	    type_enforce
	    foreign_atomic
	    heap_abstract
	    effect_property)
   (export  (cse exp p? *pred-m* *pred-i* *val-m* *val-i*)))

;*---------------------------------------------------------------------*/
;*    cse ...                                                          */
;*---------------------------------------------------------------------*/
(define (cse exp p? *pred-m* *pred-i* *val-m* *val-i*)
   (trace remove #\Newline "remove   : " (shape exp) #\Newline
	         " *pred-m*: " (shape *pred-m*) #\Newline
	         " *pred-i*: " (shape *pred-i*) #\Newline
	         " *val-m* : " (shape *val-m*) #\Newline
	         " *val-i* : " (shape *val-i*) #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (trace remove "atom: " (shape exp) #\Newline)
       (if (and (local? exp)
		(not (null? (local-info exp))))
	   (local-info exp)
	   exp))
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- function --------------------------------------------------------*/
      (((or function function-extra-light function-light) ?-)
       (set-car! (cdr exp) (cse (cadr exp) #f
				*pred-m* *pred-i* *val-m* *val-i*))
       exp)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (set-car! (cdr exp)
		 (cse (cadr exp) #f *pred-m* *pred-i* *val-m* *val-i*))
       (set-car! (cddr exp)
		 (cse (caddr exp) #f *pred-m* *pred-i* *val-m* *val-i*))
       (set-car! (cdddr exp)
		 (cse (cadddr exp) #f *pred-m* *pred-i* *val-m* *val-i*))
       exp)
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (set-car! (cdr exp) (cse (cadr exp) #t
				*pred-m* *pred-i* *val-m* *val-i*))
       (let ((test-value (test-value (cadr exp) *pred-m* *pred-i*)))
	  (cond
	     ((null? test-value)
	      (cse/predicat exp p? *pred-m* *pred-i* *val-m* *val-i*))
	     (test-value
	      (cse (caddr exp) p? *pred-m* *pred-i* *val-m* *val-i*))
	     (else
	      (cse (cadddr exp) p? *pred-m* *pred-i* *val-m* *val-i*)))))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (cse test #f *pred-m* *pred-i* *val-m* *val-i*))
       (let ((mutation? (mutation? test)))
	  (let ((*new-pred-m* (if mutation? '() *pred-m*))
		(*new-val-m*  (if mutation? '() *val-m*)))
	     (let loop ((hook clauses))
		(if (null? hook)
		    exp
		    (begin
		       (set-car! (cdar hook)
				 (cse (cadr (car hook))
				      p? 
				      *new-pred-m* *pred-i*
				      *new-val-m* *val-i*))
		       (loop (cdr hook))))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (let loop ((hook     (cdr exp))
		  (*pred-m* *pred-m*)
		  (*val-m*  *val-m*))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (cse (car hook)
				     #f
				     *pred-m* *pred-i* *val-m* *val-i*))
		 (if (mutation? (car hook))
		     (loop (cdr hook) '() '())
		     (loop (cdr hook) *pred-m* *val-m*))))))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-) 
       (set-car! (cddr exp) (cse (caddr exp) #f
				 *pred-m* *pred-i* *val-m* *val-i*))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (cse-let exp p? *pred-m* *pred-i* *val-m* *val-i*))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
      (for-each (lambda (b)
		   (local-info-set! (car b) '())
		   (for-each (lambda (f)
				(local-info-set! f '()))
			     (cadr b)))
		bindings)
      (set-car! (cddr exp) (cse (caddr exp) p?
				*pred-m* *pred-i* *val-m* *val-i*))
      (let loop ((hook bindings))
	  (if (null? hook)
	      exp
	      (let ((binding (car hook)))
		 (set-car! (cddr binding)
			   (cse (caddr binding) #f
				*pred-m* *pred-i* *val-m* *val-i*))
		 (loop (cdr hook))))))
;*--- block & return-from ---------------------------------------------*/
      (((or block return-from) . ?-)
       (set-car! (cddr exp) (cse (caddr exp) #f *pred-m* *pred-i*
				 *val-m* *val-i*))
       exp)
;*--- funcall-extra-light ---------------------------------------------*/
      (((or apply
	    funcall
	    funcall-medium
	    funcall-light
	    (funcall-extra-light . ?-)) . ?-)
       (let loop ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (cse (car hook) p? *pred-m* *pred-i*
				     *val-m* *val-i*))
		 (loop (cdr hook))))))
;*--- application -----------------------------------------------------*/
      (else
       (cse-application exp p? *pred-m* *pred-i* *val-m* *val-i*))))

;*---------------------------------------------------------------------*/
;*    test-value ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-value exp *pred-m* *pred-i*)
   (trace remove "test-value: " (shape exp) #\Newline)
   (cond
      ((side-effect? exp)
       ;; ce test est juste utile pour supprimer les recherches car
       ;; une fonction qui fait des effets de bords ne peut en aucun
       ;; car etre rangee dans une des piles.
       '())
      ((boolean? exp)
       ;; cas trivial mais possible (grace a la 0cfa)
       exp)
      (else
       (let ((cell (smart-assoc exp *pred-m*)))
	  (if (pair? cell)
	      (cdr cell)
	      (let ((cell (smart-assoc exp *pred-i*)))
		 (if (pair? cell)
		     (cdr cell)
		     '())))))))

;*---------------------------------------------------------------------*/
;*    cse/predicat ...                                                 */
;*---------------------------------------------------------------------*/
(define (cse/predicat exp p? *pred-m* *pred-i* *val-m* *val-i*)
   (let ((test (cadr exp)))
      (cond
	 ((mutation? test)
	  (set-car! (cddr exp)
		    (cse (caddr exp) p? '() *pred-i* '() *val-i*))
	  (set-car! (cdddr exp)
		    (cse (cadddr exp) p? '() *pred-i* '() *val-i*))
	  exp)
	 ((side-effect? test)
	  (set-car! (cddr exp)
		    (cse (caddr exp) p? *pred-m* *pred-i* *val-m* *val-i*))
	  (set-car! (cdddr exp)
		    (cse (cadddr exp) p? *pred-m* *pred-i* *val-m* *val-i*))
	  exp)
	 ((mutable? test)
	  (set-car! (cddr exp)
		    (cse (caddr exp) p?
			 (cons (cons test #t) *pred-m*) *pred-i*
			 *val-m* *val-i*))
	  (set-car! (cdddr exp)
		    (cse (cadddr exp) p?
			 (cons (cons test #f) *pred-m*) *pred-i*
			 *val-m* *val-i*))
	  exp)
	 (else
	  (set-car! (cddr exp)
		    (cse (caddr exp) p?
			 *pred-m* (cons (cons test #t) *pred-i*)
			 *val-m* *val-i*))
	  (set-car! (cdddr exp)
		    (cse (cadddr exp) p?
			 *pred-m* (cons (cons test #f) *pred-i*)
			 *val-m* *val-i*))
	  exp))))
	  
;*---------------------------------------------------------------------*/
;*    cse-let ...                                                      */
;*    -------------------------------------------------------------    */
;*    Il n'y a que cette fonction qui memorise des sous-expressions.   */
;*    Tous ce qui ne passe pas par des `let's n'est pas memorise.      */
;*    L'inlining en -O2 genere enormement de `let' ce qui augmente     */
;*    le nombre de sous-expressions communes qu'on peut supprimer ici. */
;*---------------------------------------------------------------------*/
(define (cse-let exp p? *pred-m* *pred-i* *val-m* *val-i*)
   (let ((mutation-seen? #f))
      (let loop ((bindings      (cadr exp))
		 (tail          '())
		 (*new-pred-m*  *pred-m*)
		 (*new-pred-i*  *pred-i*)
		 (*new-val-m*   *val-m*)
		 (*new-val-i*   *val-i*))
;*--- loop-with-cut! --------------------------------------------------*/
	 (define (loop-with-cut!)
	    (cond
	       ((null? tail)
		(if (null? (cdr bindings))
		    ;; aucune liaison ne reste
		    (loop '()
			  '()
			  *new-pred-m*
			  *new-pred-i*
			  *new-val-m* 
			  *new-val-i*)
		    (begin
		       (set-car! (cdr exp) (cdr (cadr exp)))
		       (loop (cdr bindings)
			     '()
			     *new-pred-m*
			     *new-pred-i*
			     *new-val-m* 
			     *new-val-i*))))
	       (else
		(set-cdr! tail (cdr bindings))
		(loop (cdr bindings)
		      tail
		      *new-pred-m*
		      *new-pred-i*
		      *new-val-m* 
		      *new-val-i*))))
;*--- cse-let(body) ---------------------------------------------------*/
	 (cond
	    ((null? bindings)
	     (let ((body (if mutation-seen?
			     (cse (caddr exp) p? 
				  '() *new-pred-i* '() *new-val-i*)
			     (cse (caddr exp) p? 
				  *new-pred-m* *new-pred-i*
				  *new-val-m* *new-val-i*))))
		(if (null? tail)
		    body
		    (begin
		       (set-car! (cddr exp) body)
		       exp))))
	    (else
	     (let* ((binding (car bindings))
		    (var     (car binding))
		    (val     (cadr binding)))
		(trace remove "binding: " (shape binding) #\Newline
		              "side-effect?: " (side-effect? (cadr binding))
			      #\Newline
		              "mutable?: " (mutable? (cadr binding))
			      #\Newline
			      "mutation?: " (mutation? (cadr binding))
			      #\Newline)
		(local-info-set! var '())
		(set-car! (cdr binding)
			  (cse val #f *pred-m* *pred-i* *val-i* *val-i*))
		(cond
		   ((eq? (local-access var) 'write)
		    ;; la variable est affecte dans le let, on ne fait donc
		    ;; aucune optimisation dessus.
		    (loop (cdr bindings)
			  bindings
			  *new-pred-m*
			  *new-pred-i*
			  *new-val-m* 
			  *new-val-i*))
		   ((local? (cadr binding))
		    ;; c'est une liaison qui porte sur deux variables.
		    (if (eq? (local-access (cadr binding)) 'write)
			(loop (cdr bindings)
			      bindings
			      *new-pred-m*
			      *new-pred-i*
			      *new-val-m* 
			      *new-val-i*)
			(begin
			   ;; on marque l'expression commune.
			   (local-info-set! var (cadr binding))
			   ;; on coupe la branche de la liaison
			   (loop-with-cut!))))
		   (else
		    (if (side-effect? (cadr binding))
			(begin
			   (if (mutation? (cadr binding))
			       (set! mutation-seen? #t))
			   (loop (cdr bindings)
				 bindings
				 *new-pred-m*
				 *new-pred-i*
				 *new-val-m* 
				 *new-val-i*))
			(let ((oval (let ((ce (smart-assoc (cadr binding)
							   *val-m*)))
				       (if (pair? ce)
					   (cdr ce)
					   (let ((ce (smart-assoc
						      (cadr binding)
						      *val-i*)))
					      (if (pair? ce)
						  (cdr ce)
						  '()))))))
			   (if (not (null? oval))
			       ;; on a deja calcule cette expression
			       (begin
				  ;; on marque l'expression commune.
				  (local-info-set! var oval)
				  ;; on coupe la branche de la liaison
				  (loop-with-cut!))
			       ;; on n'a jamais calcule cette expression
			       (if (mutable? (cadr binding))
				   (loop (cdr bindings)
					 bindings
					 *new-pred-m*
					 (new-pred-i binding *new-pred-i*)
					 (cons (cons (cadr binding)
						     var)
					       *new-val-m*)
					 *new-val-i*)
				   (loop (cdr bindings)
					 bindings
					 *pred-m*
					 (new-pred-i binding *new-pred-i*)
					 *new-val-m*
					 (cons (cons (cadr binding)
						     var)
					       *new-val-i*))))))))))))))

;*---------------------------------------------------------------------*/
;*    new-pred-i ...                                                   */
;*    -------------------------------------------------------------    */
;*    On enrichie la liste des tests qu'on on connait le type d'une    */
;*    expression d'un `let'.                                           */
;*---------------------------------------------------------------------*/
(define (new-pred-i binding *pred-i*)
   (let ((tof (type-of (cadr binding))))
      (cond
	 ((eq? tof *bbool*)
	  (cons (cons
		 (abstract-boolean? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *bint*)
	  (cons (cons
		 (abstract-integer? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *breal*)
	  (cons (cons
		 (abstract-real? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *bpair*)
	  (cons (cons
		 (abstract-pair? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *bchar*)
	  (cons (cons
		 (abstract-char? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *bsymbol*)
	  (cons (cons
		 (abstract-symbol? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *bstring*)
	  (cons (cons
		 (abstract-string? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *bvector*)
	  (cons (cons
		 (abstract-vector? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *bstruct*)
	  (cons (cons
		 (abstract 'c-struct? (car binding))
		 #t)
		*pred-i*))
	 ((eq? tof *bforeign*)
	  (cons (cons
		 (abstract 'fc-oreign? (car binding))
		 #t)
		*pred-i*))
	 (else
	  *pred-i*))))

;*---------------------------------------------------------------------*/
;*    cse-application ...                                              */
;*---------------------------------------------------------------------*/
(define (cse-application exp p? *pred-m* *pred-i* *val-m* *val-i*)
   (trace remove "cse-application: " (shape exp) #\Newline)
   (let loop ((hook exp))
      (if (null? hook)
	  (if p? (let ((value (test-value exp *pred-m* *pred-i*)))
		    (if (null? value)
			(app-value exp p? *val-m* *val-i*)
			value))
	      (app-value exp p? *val-m* *val-i*))
	  (begin
	     (set-car! hook (cse (car hook) #f
				 *pred-m* *pred-i* *val-m* *val-i*))
	     (loop (cdr hook))))))

;*---------------------------------------------------------------------*/
;*    app-value ...                                                    */
;*---------------------------------------------------------------------*/
(define (app-value exp p? *val-m* *val-i*)
   (trace remove "app-value: " (shape exp) #\Newline)
   (if (side-effect? exp)
       ;; meme remarque que dans la fonction `test-value' ce test
       ;; sert juste a supprimer les recherches dans les stacks
       ;; pour les cas triviaux.
       exp
       (let ((cell (smart-assoc exp *val-m*)))
	  (if (pair? cell)
	      (cdr cell)
	      (let ((cell (smart-assoc exp *val-i*)))
		 (if (pair? cell)
		     (cdr cell)
		     exp))))))

;*---------------------------------------------------------------------*/
;*    failure? ...                                                     */
;*---------------------------------------------------------------------*/
(define (failure? exp)
   (match-case exp
      ((failure ?- ?- ?-)
       #t)
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    smart-assoc ...                                                  */
;*    -------------------------------------------------------------    */
;*    C'est comme un `assoc' mais on ne test pas avec `equal?'         */
;*    mais `smart-equal?'. Je suis oblige de faire cette fonction car  */
;*    j'ai a tester des arbre de syntaxe abstraite. Donc des arbres    */
;*    qui peuvent contenir des structures circulaires. Si on utilise   */
;*    `equal?' on peut boucler dedans.                                 */
;*---------------------------------------------------------------------*/
(define (smart-assoc obj alist)
    (if (not (null? alist))
        (let ((cary (car alist)))
           (if (smart-equal? obj (car cary))
	       cary
	       (smart-assoc obj (cdr alist))))
        #f))

;*---------------------------------------------------------------------*/
;*    smart-equal? ...                                                 */
;*---------------------------------------------------------------------*/
(define (smart-equal? l1 l2)
   (cond
      ((eq? l1 l2)
       #t)
      ((and (pair? l1) (pair? l2))
       (let loop ((l1 l1)
		  (l2 l2))
	  (cond
	     ((null? l1)
	      (null? l2))
	     ((null? l2)
	      #f)
	     ((eq? (car l1) (car l2))
	      (loop (cdr l1) (cdr l2)))
	     (else
	      #f))))
      (else
       #f)))
	      
