;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Curry/fiable.scm ...     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 15 15:37:59 1993                          */
;*    Last change :  Wed Dec 15 16:09:59 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On fait une passe sur le code pour trouver les fonctions         */
;*    locales qui ne sont pas curryfiable.                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module curry_fiable
   (include "Var/variable.sch")
   (import  tools_shape)
   (export  (mark-uncurryfiable! body)))

;*---------------------------------------------------------------------*/
;*    mark-uncurryfiable! ...                                          */
;*---------------------------------------------------------------------*/
(define (mark-uncurryfiable! exp)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?atom)
       (if (and (local? atom)
		(eq? (local-class atom) 'function))
	   ;; on marque la fonction
	   (local-info-set! atom #f)))
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       'done)
;*--- pragma ----------------------------------------------------------*/
      ((pragma (? string?))
       'done)
;*--- assert ----------------------------------------------------------*/
      ((assert . ?-)
       (for-each mark-uncurryfiable! (cdr exp)))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (for-each mark-uncurryfiable! body))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (for-each mark-uncurryfiable! (cdr exp)))
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (for-each (lambda (b)
		    (mark-uncurryfiable! (cadr b)))
		 bindings)
       (mark-uncurryfiable! body))
;*--- labels ----------------------------------------------------------*/
      ((labels ((?fun (?-) ?new-body))
	  ?fun)
       (mark-uncurryfiable! new-body))
      ((labels ?bindings ?body)
       (for-each (lambda (b)
		    (mark-uncurryfiable! (caddr b)))
		 bindings)
       (mark-uncurryfiable! body))
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (for-each mark-uncurryfiable! (cdr exp)))
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit (?a) ?body)
       (mark-uncurryfiable! body))
;*--- apply -----------------------------------------------------------*/
      ((apply ?proc ?arg)
       (mark-uncurryfiable! proc)
       (mark-uncurryfiable! arg))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (mark-uncurryfiable! test)
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (mark-uncurryfiable! (cadr (car hook)))
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((if . ?-)
       (for-each mark-uncurryfiable! (cdr exp)))
;*--- application -----------------------------------------------------*/
      (else
       (for-each mark-uncurryfiable! exp))))
