;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Curry/walk.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 12 09:10:39 1993                          */
;*    Last change :  Tue Dec 28 08:28:57 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On fait une passe particuliere pour optimiser cette satanee      */
;*    curryfication des programmes ML                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module curry_walk
   (include "Var/variable.sch"
	    "Curry/curry.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    tools_beta
	    var_declare
	    scan_lexical
	    engine_param
	    curry_exp
	    curry_fiable)
   (export  (curry-walk schemes)
	    (mark-curry-info! name info)
	    (unmark-curry-info! name)
	    (make-curry-function-name old-name n)))

;*---------------------------------------------------------------------*/
;*    curry-walk ...                                                   */
;*    -------------------------------------------------------------    */
;*    On est oblige de faire deux parcours du code. Le premier pour    */
;*    regler le cas des definitions globales, le second pour changer   */
;*    les defintions des fonctions.                                    */
;*---------------------------------------------------------------------*/
(define (curry-walk tree)
   (verbose "   . Curry" #\Newline)
   (let ((_walk (let loop ((walk tree)
			   (res  '()))
		   (if (null? walk)
		       (reverse! res)
		       (let ((new-exps (curry-scan-global-var (car walk))))
			  (loop (cdr walk)
				(append new-exps res)))))))
      (let loop ((walk _walk))
	 (if (null? walk)
	     (begin
		(unmark-all-curry-info!)
		_walk)
	     (let ((v (car walk)))
		(if (not (curry? (global-info v)))
		    ;; on ne touche au body que si la fonction n'est pas
		    ;; deja de-curryfiee
		    (function-body-set! (global-value v)
					(curry-expression
					 (function-body (global-value v)))))
		(loop (cdr walk)))))))

;*---------------------------------------------------------------------*/
;*    make-curry-function-name ...                                     */
;*---------------------------------------------------------------------*/
(define (make-curry-function-name old-name n)
   (string->symbol (string-append
		    (symbol->string old-name) "-"
		    (integer->string n) "-"
		    (symbol->string (gensym)))))

;*---------------------------------------------------------------------*/
;*    curry-scan-global-var ...                                        */
;*---------------------------------------------------------------------*/
(define (curry-scan-global-var var)
   (let* ((function (global-value var))
	  (args     (function-args function))
	  (body     (function-body function)))
      (mark-uncurryfiable! body)
      (if (or (not (pair? args)) (not (null? (cdr args))))
	  (list var)
	  (let ((curry (find-curry-depth (function-arity function)
					 (car args) body)))
	     (if (not (curry? curry))
		 (list var)
		 (let ((old-curry (get-curry-info var (curry-depth curry))))
		    (if (curry? old-curry)
			;; la fonction est deja de-curryfie
			(list var)
			(let* ((new-fun-name (make-curry-function-name
					      (global-name var)
					      (curry-depth curry)))
			       (new-args     (map (lambda (v)
						     (allocate-local-variable
						      (local-name v)))
						  (curry-args curry)))
			       (new-fun      (declare-global-procedure!
					      new-fun-name
					      new-args
					      *module-name*
					      'static)))
			   (curry-new-fun-set! curry new-fun)
			   ;; on fait une copie du cons car on le ...
			   (function-body-set! (global-value new-fun)
					       (beta-reduce
						(cons (car (curry-body curry))
						      (cdr (curry-body curry)))
						(map cons
						     (curry-args curry)
						     new-args)))
;*---------------------------------------------------------------------*/
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    Attention, il faut bien faire attention. Comme on fait des       */
;*    modifs physique sur le corps des fonctions, quand on scan des    */
;*    `labels', il ne faut *pas* utiliser les champs `body' des        */
;*    fonctions locales. Il faut absolument, regarder le code Beta-    */
;*    reduit. Car le body est reconstruit (dans le cons qui est juste  */
;*    au dessus) et donc il n'y a plus d'egalite physique.             */
;*---------------------------------------------------------------------*/
			   (function-args-set! (global-value new-fun) new-args)
			   ;; ... detruit ici
			   (set-car! (curry-body curry) new-fun)
			   (set-cdr! (curry-body curry)
				     (reverse (reverse! (curry-args curry))))
			   (mark-curry-info! var curry)
			   (list var new-fun)))))))))

;*---------------------------------------------------------------------*/
;*    *curry-info* ...                                                 */
;*---------------------------------------------------------------------*/
(define *curry-info* '())

;*---------------------------------------------------------------------*/
;*    mark-curry-info! ...                                             */
;*---------------------------------------------------------------------*/
(define (mark-curry-info! var info)
   (if (global? var)
       (begin
	  (global-info-set! var info)
	  (set! *curry-info* (cons var *curry-info*)))
       (local-info-set! var info)))

;*---------------------------------------------------------------------*/
;*    unmark-curry-info! ...                                           */
;*---------------------------------------------------------------------*/
(define (unmark-curry-info! var)
   (global-info-set! var '()))

;*---------------------------------------------------------------------*/
;*    unmark-all-curry-info! ...                                       */
;*---------------------------------------------------------------------*/
(define (unmark-all-curry-info!)
   (for-each unmark-curry-info! *curry-info*))
