;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.5b/Hoist/hoist.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 12 10:14:02 1993                          */
;*    Last change :  Thu Oct 21 08:58:59 1993 (serrano)                */
;*                                                                     */
;*    un petit code qui fait du `failure-hoisting'                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module hoist_fail
   (include "Tools/trace.sch")
   (import  tools_shape)
   (export  (hoist exp)))

;*---------------------------------------------------------------------*/
;*    movable? ...                                                     */
;*---------------------------------------------------------------------*/
(define (movable? exp)
   (match-case exp
      ((cif ?- ?- (failure . ?-))
       #t)
      ((let . ?-)
       #t)
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    hoist ...                                                        */
;*    exp --> exp                                                      */
;*    -------------------------------------------------------------    */
;*    On remonte le plus haut possible tous les tests qui debouchent   */
;*    sur une failure                                                  */
;*---------------------------------------------------------------------*/
(define (hoist exp)
   (trace hoist "hoist: " (shape exp) #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       exp)
;*--- function --------------------------------------------------------*/
      (((or function function-extra-light function-light) ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       exp)
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (set-car! (cdr exp) (hoist (cadr exp)))
       (set-car! (cddr exp) (hoist (caddr exp)))
       (set-car! (cdddr exp) (hoist (cadddr exp)))
       (if (movable? (cadr exp))
	   (inject-if! exp (cdr exp))
	   exp))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (hoist test))
       (let loop ((hook clauses))
	  (if (null? hook)
	      (if (movable? (caddr exp))
		  (inject-case! exp (cddr exp))
		  exp)
	      (begin
		 (set-car! (cdr (car hook)) (hoist (cadr (car hook))))
		 (loop (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? hook)
	      exp
	      (match-case (car hook)
		 ((failure . ?-)
		  exp)
		 (else
		  (set-car! hook (hoist (car hook)))
		  (if (null? (cdr hook))
		      (loop (cdr hook))
		      (match-case (car hook)
			 (((or labels let) ?- . ?body)
			  (let ((todo (link! body (cdr hook))))
			     (set-cdr! hook '())
			     (loop todo)))
			 (else
			  (loop (cdr hook)))))))))) 
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (set-car! (cddr exp) (hoist (caddr exp)))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (set-car! (cddr exp) (hoist (caddr exp)))
       (hoist-let exp (cadr exp)))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (set-car! (cddr exp) (hoist (caddr exp)))
       (for-each (lambda (binding)
		    (set-car! (cddr binding) (hoist (caddr binding))))
		 bindings)
       exp)
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (set-car! (cddr exp) (hoist (caddr exp)))
       exp)
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (set-car! (cddr exp) (hoist (caddr exp)))
       exp)
;*--- funcall & apply -------------------------------------------------*/
      (((or apply
	    funcall
	    funcall-medium
	    funcall-light
	    (funcall-extra-light . ?-)) . ?-)
       (hoist-application exp (cdr exp)))
;*--- application -----------------------------------------------------*/
      (else
       (set-car! exp (hoist (car exp)))
       (hoist-application exp (cdr exp)))))

;*---------------------------------------------------------------------*/
;*    hoist-let ...                                                    */
;*---------------------------------------------------------------------*/
(define (hoist-let exp bindings)
   (trace hoist "hoist-let: " (shape exp) #\Newline
	         "     bdgs: " (shape bindings) #\Newline)
   (let loop ((hook bindings))
      (if (null? hook)
	  exp
	  (begin
	     (set-car! (cdr (car hook)) (hoist (cadr (car hook))))
	     (if (movable? (cadr (car hook)))
		 (inject-bindings! exp hook)
		 (loop (cdr hook)))))))

;*---------------------------------------------------------------------*/
;*    hoist-application ...                                            */
;*---------------------------------------------------------------------*/
(define (hoist-application exp args)
   (trace hoist "application: " (shape exp) #\Newline
	         "       args: " (shape args) #\Newline)
   (let loop ((hook args))
      (if (null? hook)
	  exp
	  (begin
	     (set-car! hook (hoist (car hook)))
	     (if (movable? (car hook))
		 (inject! exp hook)
		 (loop (cdr hook)))))))

;*---------------------------------------------------------------------*/
;*    inject! ...                                                      */
;*---------------------------------------------------------------------*/
(define (inject! exp place)
   (let ((futur-exp   (car place)))
      (set-car! place (caddr futur-exp))
      (let ((cutted-exp place))
	 (if (movable? (car cutted-exp))
	     (set-car! (cddr futur-exp)
		       (inject! (hoist-application exp (cdr cutted-exp))
				cutted-exp))
	     (set-car! (cddr futur-exp)
		       (hoist-application exp (cdr cutted-exp))))
	 futur-exp)))
      
;*---------------------------------------------------------------------*/
;*    inject-if! ...                                                   */
;*---------------------------------------------------------------------*/
(define (inject-if! exp place)
   (trace hoist "inject-i!: " (shape exp) #\Newline)
   (trace hoist "        p: " (shape place) #\Newline)
   (let ((futur-exp   (car place)))
      (set-car! place (caddr futur-exp))
      (let ((cutted-exp place))
	 (if (movable? (car cutted-exp))
	     (set-car! (cddr futur-exp) (inject-if! exp (cdr exp)))
	     (set-car! (cddr futur-exp) exp))
	 futur-exp)))
		
;*---------------------------------------------------------------------*/
;*    inject-case! ...                                                 */
;*---------------------------------------------------------------------*/
(define (inject-case! exp place)
   (trace hoist "inject-c!: " (shape exp) #\Newline)
   (trace hoist "        p: " (shape place) #\Newline)
   (let ((futur-exp   (car place)))
      (set-car! place (caddr futur-exp))
      (let ((cutted-exp place))
	 (if (movable? (car cutted-exp))
	     (set-car! (cddr futur-exp) (inject-case! exp (cddr exp)))
	     (set-car! (cddr futur-exp) exp))
	 futur-exp)))
		
;*---------------------------------------------------------------------*/
;*    inject-bindings! ...                                             */
;*---------------------------------------------------------------------*/
(define (inject-bindings! exp place)
   (let ((futur-exp   (car (cdar place))))
      (set-car! (cdar place) (caddr futur-exp))
      (let ((cutted-exp  (cdar place)))
	 (if (movable? (car cutted-exp))
	     (set-car! (cddr futur-exp)
		       (inject! (hoist-let exp (cdr place)) cutted-exp))
	     (set-car! (cddr futur-exp) (hoist-let exp (cdr place))))
	 futur-exp)))
		
;*---------------------------------------------------------------------*/
;*    link! ...                                                        */
;*---------------------------------------------------------------------*/
(define (link! body1 body2)
   (if (or (not (pair? (car body1)))
	   (not (eq? (car (car body1)) 'begin)))
       (begin
	  (set-car! body1 `(begin ,(car body1) ,@body2))
	  (cddr (car body1)))
       (let ((body1 (car body1)))
	  (do ((a body1 b)
	       (b (cdr body1) (cdr b)))
		((null? b)
		 (set-cdr! a body2)
		 body1))
	  body2)))

