;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Integ/cn.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 15 13:22:34 1993                          */
;*    Last change :  Thu Jan 20 17:54:56 1994 (serrano)                */
;*                                                                     */
;*    Les calculs des proprietes U, Cn et Ct.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module integ_cn
   (include "Integ/integ.sch"
	    "Var/variable.sch"
	    "Tools/trace.sch")
   (import  integ_agraph
	    tools_shape
	    integ_agraph)
   (export  (U!)
	    (Cn&Ct! var A)))

;*---------------------------------------------------------------------*/
;*    U! ...                                                           */
;*---------------------------------------------------------------------*/
(define (U!)
   (let loop ((Phi *phi*))
      (if (null? Phi)
	  (trace-U)
	  (let* ((p     (car Phi))
		 (integ (if (local? p)
			    (local-info p)
			    (global-info p))))
	     (integ-U-set! integ (=fx (length (integ-K* integ)) 1))
	     (loop (cdr Phi))))))

;*---------------------------------------------------------------------*/
;*    Cn&Ct! ...                                                       */
;*---------------------------------------------------------------------*/
(define (Cn&Ct! var A)
   (G var (Cs A)))

;*---------------------------------------------------------------------*/
;*    Cs ...                                                           */
;*---------------------------------------------------------------------*/
(define (Cs A)
   (let loop ((As  A)
	      (GS '()))
      (if (null? As)
	  (begin
	     (trace-c)
	     (trace integ "Apres Cs, Gs: " (shape Gs) #\Newline)
	     Gs)
	  (let* ((A  (car As))
		 (f  (car A))
		 (g  (cadr A))
		 (k  (caddr A))
		 (fi (if (global? f)
			 (global-info f)
			 (local-info f)))
		 (gi (if (global? g)
			 (global-info g)
			 (local-info g))))
	     (cond
		((globalized? g)
		 (loop (cdr As) Gs))
		((eq? k 'tail)
		 (integ-Ct-set! fi (cons g (integ-Ct fi)))
		 (if (and (not (eq? f g))
			  (not (memq g (integ-cont fi))))
		     (integ-cont-set! fi (cons g (integ-cont fi))))
		 (loop (cdr As) Gs))
		((eq? k 'escape)
		 (if (not (memq g (integ-cont fi)))
		     (integ-cont-set! fi (cons g (integ-cont fi))))
		 (loop (cdr As) Gs))
		((integ-U gi)
		 (integ-Ct-set! fi (cons g (integ-Ct fi)))
		 (if (not (memq g (integ-cont fi)))
		     (integ-cont-set! fi (cons g (integ-cont fi))))
		 (loop (cdr As) Gs))
		(else
		 (integ-Cn-set! fi (cons g (integ-Cn fi)))
		 (if (not (integ-G? gi))
		     (begin
			(integ-G?-set! gi #t)
			(loop (cdr As) (cons g Gs)))
		     (loop (cdr As) Gs))))))))

;*---------------------------------------------------------------------*/
;*    G ...                                                            */
;*---------------------------------------------------------------------*/
(define (G var gs)
   ;; on commence par marquer toutes les continuations de la fonction globale
   ;; (et toutes les continuations des continuations).
   (let loop ((cont (if (local? var)
			(integ-cont (local-info var))
			(integ-cont (global-info var)))))
      (if (null? cont)
	  'done
	  (let ((v (car cont)))
	     (cond
		((global? v)
		 (loop (cdr cont)))
		((not (null? (integ-integrable (local-info v))))
		 (loop (cdr cont)))
		((local? v)
		 (integ-integrable-set! (local-info v) var)
		 (loop (append (integ-cont (local-info v)) cont)))))))
   ;; on boucle sur toutes les fonctions qui vont etre globalisees
   (let ((*globalised* gs))
      (let loop ((globaliseur *globalised*))
	 (if (null? globaliseur)
	     (begin
		(trace-c)
		(set-integrator! *globalised*)
		(trace-c)
		(trace integ "G : " (shape *globalised*) #\Newline)
		*globalised*)
	     (let ((globeur (car globaliseur)))
		;; on marque toutes les continuation de `globeur'
		(let liip ((globaliseur (cdr globaliseur))
			   (conts       (integ-cont (local-info globeur))))
		   (if (null? conts)
		       (loop globaliseur)
		       (let ((c (car conts)))
			  (if (global? c)
			      (liip globaliseur (cdr conts))
			      (let ((integ (local-info c)))
				 (trace integ "G.loop( " (shape c) ","
					(shape globeur) " ): "
					(shape (integ-integrable integ))
					" G? : " (integ-G? integ)
					" oldG?: " (integ-old-G? integ)
					#\Newline)
				 (cond
				    ((eq? (integ-G? integ) #t)
				     (liip globaliseur (cdr conts)))
				    ((eq? (integ-old-G? integ) #t)
				     (liip globaliseur (cdr conts)))
				    ((null? (integ-integrable integ))
				     (integ-integrable-set! integ globeur)
				     (let ((globeurs (mark-integrated-cont!
						      integ
						      globeur)))
					(trace integ "globeurs: "
					       (shape globeurs) #\Newline)
					(set! *globalised*
					      (append globeurs *globalised*))
					(liip (append globeurs globaliseur)
					      (cdr conts))))
				    ((eq? (integ-integrable integ) globeur)
				     (liip globaliseur (cdr conts)))
				    (else
				     (integ-G?-set! integ #t)
				     (set! *globalised* (cons c *globalised*))
				     (liip (cons c globaliseur)
					   (cdr conts))))))))))))))

;*---------------------------------------------------------------------*/
;*    mark-integrated-cont! ...                                        */
;*---------------------------------------------------------------------*/
(define (mark-integrated-cont! integ globeur)
   (let loop ((cont (integ-cont integ))
	      (res  '()))
      (trace integ "mark-integrated-cont!( " (shape cont) ", " (shape globeur)
	     " )" #\Newline)
      (if (null? cont)
	  res
	  (let ((c (car cont)))
	     (if (global? c)
		 (loop (cdr cont) res)
		 (let ((integc (local-info c)))
		    (trace integ "   " (shape c) " ... "
			   (shape (integ-integrable integc))
			   "  (G?: " (integ-G? integc) ")"
			   #\Newline)
		    (cond
		       ((eq? (integ-G? integc) #t)
			(loop (cdr cont) res))
		       ((eq? (integ-old-G? integc) #t)
			(loop (cdr cont) res))
		       ((null? (integ-integrable integc))
			(integ-integrable-set! integc globeur)
			(loop (cdr cont)
			      (append res
				      (mark-integrated-cont! integc globeur))))
		       ((eq? (integ-integrable integc) globeur)
			(loop (cdr cont) res))
		       (else
			(trace integ "   ==> G( " (shape c) ") <==" #\Newline)
			(integ-G?-set! integc #t)
			(loop (cdr cont) (cons c res))))))))))

;*---------------------------------------------------------------------*/
;*    set-integrator! ...                                              */
;*---------------------------------------------------------------------*/
(define (set-integrator! Gs)
   (let loop ((Gs Gs))
      (cond
	 ((null? Gs)
	  'done)
	 ((global? (car Gs))
	  (loop (cdr Gs)))
	 ((eq? (integ-old-G? (local-info (car Gs))) #t)
	  (loop (cdr Gs)))
	 (else
	  (let* ((G          (car Gs))
		 (integ      (local-info G)))
	     (let liip ((cont (integ-cont integ)))
		(if (null? cont)
		    (loop (cdr Gs))
		    (let ((pcont (car cont)))
		       (trace (integ loop)
			      "set-integrator!: " (shape (car Gs))
			      #\Newline
			      "          pcont: " (shape pcont)
			      #\Newline)
		       (cond
			  ((or (global? pcont)
			       (eq? (integ-G? (local-info pcont)) #t)
			       (eq? (integ-old-G? (local-info pcont)) #t))
			   (liip (cdr cont)))
			  ((not (null? (integ-integrator (local-info pcont))))
			   (liip (cdr cont)))
			  (else
			   (integrates-in! G pcont)
			   (liip (cdr cont))))))))))))

;*---------------------------------------------------------------------*/
;*    integrates-in! ...                                               */
;*---------------------------------------------------------------------*/
(define (integrates-in! Glocal local)
   (trace (cgen loop) "integrates-in!: " (shape Glocal) " " (shape local)
	  #\Newline)
   (if (not (eq? (integ-owner (local-info local)) Glocal))
       (begin
	  (integ-integrator-set! (local-info local) Glocal)
	  (integ-integrates-set! (local-info Glocal)
				 (cons local
				       (integ-integrates
					(local-info Glocal))))))
   ;; maintenant qu'on a integree la fonction principale, il faut
   ;; integrer toutes les sous fonctions.
   (for-each (lambda (c)
		(cond
		   ((or (global? c)
			(eq? (integ-G? (local-info c)) #t)
			(eq? (integ-old-G? (local-info c)) #t))
		    'nothing)
		   ((belong? c local)
		    (for-each (lambda (f)
				 (integrates-in! Glocal f))
			      (find-not-belonging-cont c local))
		    'nothing)
		   ((not (null? (integ-integrator (local-info c))))
		    'nothing)
		   (else
		    ;; non, on l'integre aussi
		    (integrates-in! Glocal c))))
	     (integ-cont (local-info local))))

;*---------------------------------------------------------------------*/
;*    find-not-belonging-cont ...                                      */
;*    -------------------------------------------------------------    */
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    Cette fonction est n2, il faudrait l'ameliorer, je ferai         */
;*    ca plus tard.                                                    */
;*---------------------------------------------------------------------*/
(define (find-not-belonging-cont c local)
   (let loop ((cont  (integ-cont (local-info local)))
	      (stack (list local))
	      (res   '()))
      (if (null? cont)
	  res
	  (let ((c (car cont)))
	     (cond
		((or (global? c)
		     (eq? (integ-G? (local-info c)) #t)
		     (eq? (integ-old-G? (local-info c)) #t))
		 (loop (cdr cont) stack res))
		((not (null? (integ-integrator (local-info c))))
		 (loop (cdr cont) stack res))
		((memq c stack)
		 (loop (cdr cont) stack res))
		((belong? c local)
		 (loop (append (integ-cont (local-info c)) (cdr cont))
		       (cons c stack)
		       res))
		(else
		 (loop (cdr cont)
		       (cons c stack)
		       (cons c res))))))))
  
;*---------------------------------------------------------------------*/
;*    belong? ...                                                      */
;*---------------------------------------------------------------------*/
(define (belong? qui dans)
   (let loop ((qui qui))
      (cond
	 ((eq? qui dans)
	  #t)
	 ((global? qui)
	  #f)
	 ((eq? (integ-G? (local-info qui)) #t)
	  #f)
	 ((eq? (integ-old-G? (local-info qui)) #t)
	  #f)
	 (else
	  (loop (integ-owner (local-info qui)))))))

;*---------------------------------------------------------------------*/
;*    trace-c ...                                                      */
;*---------------------------------------------------------------------*/
(define (trace-c)
   (when-trace 'integ
	       (lambda ()
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
		  (fprint *trace-port* "C: " #\Newline)
		  (for-each (lambda (p)
			       (let ((integ (if (local? p)
						(local-info p)
						(global-info p))))
				  (fprint *trace-port*
					  " --> " (shape p) #\: #\Newline
					  "   Cn        : "
					  (shape (integ-Cn integ))
					  #\Newline
					  "   Ct        : "
					  (shape (integ-Ct integ))
					  #\Newline
					  "   Cont      : "
					  (shape (integ-cont integ)))
				  (if (integ-G? integ)
				      (fprint *trace-port*
					      "   integrates: "
					      (shape
					       (integ-integrates integ))))
				  (if (not (integ-G? integ))
				      (fprint *trace-port*
					      "   integrator: " 
					      (shape (integ-integrator
						      integ))))))
			    *phi*)
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))))

;*---------------------------------------------------------------------*/
;*    trace-U ...                                                      */
;*---------------------------------------------------------------------*/
(define (trace-U)
   (when-trace 'integ
	       (lambda ()
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
		  (fprint *trace-port* "U: " #\Newline)
		  (for-each (lambda (p)
			       (let ((integ (if (local? p)
						(local-info p)
						(global-info p))))
				  (fprint *trace-port*
					  " --> " (shape p) #\:
					  (integ-U integ))))
			    *phi*)
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))))


		       
		    

	
