;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Read/import.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 16 19:52:04 1992                          */
;*    Last change :  Thu Jan 20 02:21:11 1994 (serrano)                */
;*                                                                     */
;*    On lit les modules importes                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_import
   (import parse_foreign
	   parse_import
	   read_inline
	   tools_speek
	   tools_module
	   engine_param
	   var_pragma)
   (export (read-all-imported-module imported)))

;*---------------------------------------------------------------------*/
;*    read-all-imported-module                                         */
;*---------------------------------------------------------------------*/
(define (read-all-imported-module imports)
   (let loop ((imports imports))
      (if (null? imports)
	  'done
	  (begin
	     (read-imported-module (car imports))
	     (loop (cdr imports))))))

;*---------------------------------------------------------------------*/
;*    read-imported-module ...                                         */
;*    -------------------------------------------------------------    */
;*    On import les liaisons precisees `import' mais aussi tous les    */
;*    foreign.                                                         */
;*---------------------------------------------------------------------*/
(define (read-imported-module module-require)
   (let* ((module (car module-require))
	  (wanted (cdr module-require))
	  (b      (assq module *access-table*)))
      (verbose "      [reading imported module " module "]" #\Newline)
      (if (not b)
	  (error "read-imported-module" "Can't find such module" module)
	  (let ((port (open-input-file (cdr b))))
	     (if (not (input-port? port))
		 (error "read-imported-module"
			"Can't open such file"
			(cdr b))
		 (let ((handler (lambda (escape proc mes obj)
				   (notify-error proc mes obj)
				   (input-port-display-error
				    port
				    (current-error-port))
				   (fprint (current-error-port)
					   "(file " (cdr b) ")")
				   (close-input-port port)
				   (exit -4))))
		    ;; on importe la fonction d'initialisation du module
		    (parse-imported (list (module-init-name module)) module)
		    (try
		     (let ((decl (read port)))
			(if (not (and (pair? decl)
				      (eq? (car decl) 'module)))
			    (error "read-imported-module"
				   "illegal module declaration"
				   decl)
			    ;; on recherche la liste des clauses
			    ;; d'exportation du module
			    (let ((provided (get-exported-clauses
					     (cddr decl))))
			       (if (not (eq? (cadr decl) module))
				   (warning
				    "module-declaration"
				    "conflict in module's name -- "
				    (string-append
				     (symbol->string module) " vs ")
				    (cadr decl)))
			       (parse-foreign (vector-ref provided 1) 'import)
			       (look-for-inline
				(if (null? wanted)
				    (import-everything (vector-ref provided 0)
						       module)
				    (import-wanted (vector-ref provided 0)
						   wanted 
						   module))
				port
				module)
			       (put-pragma! (vector-ref provided 2))
			       (close-input-port port))))
		     handler)))))))

;*---------------------------------------------------------------------*/
;*    import-everything ...                                            */
;*---------------------------------------------------------------------*/
(define (import-everything provided module)
   (let loop ((provided provided)
	      (inline   '()))
      (if (null? provided)
	  inline
	  (let ((s (parse-imported (car provided) module)))
	     (loop (cdr provided)
		   (if (not s)
		       inline
		       (cons s inline)))))))
	     
;*---------------------------------------------------------------------*/
;*    import-wanted ...                                                */
;*---------------------------------------------------------------------*/
(define (import-wanted provided wanted module)
   (let loop ((provided provided)
	      (inline   '())
	      (wanted   wanted))
;*---------------------------------------------------------------------*/
;*    On verifie que toutes les fonctions importees sont dans cette    */
;*    liste et en meme temps on calcule la liste des fonctions inline  */
;*    qu'on va aller chercher dans le corps du module importe.         */
;*---------------------------------------------------------------------*/
      (cond
;*--- Ok, tout est bien qui fini bien ---------------------------------*/
	 ((null? wanted)
	  inline)
;*--- Desole, on n'a pas trouve tout les exports demandes -------------*/
	 ((null? provided)
	  (let loop ((wanted wanted))
	     (if (null? (cdr wanted))
		 (error "import-wanted"
			"this function is not exported"
			(string-append
			 (string-append (symbol->string (car wanted))
					"@")
			 (symbol->string module)))
		 (begin
		    (warning
		     "module-declaration"
		     "this function is not exported -- "
		     (string-append
		      (string-append (symbol->string (car wanted))
				     "@")
		      (symbol->string module)))
		    (loop (cdr wanted))))))
;*--- On recherche un demande importation -----------------------------*/
	 (else
	  (let ((i (search-exported (car wanted) provided module)))
	     (if (not i)
		 (error "import-wanted"
			"can't find such variable"
			(string-append
			 (string-append (symbol->string (car i))
					"@")
			 (symbol->string module)))
		 (begin
		    (if (parse-imported i module)
			(loop (remq! i provided)
			      (cons (car wanted) inline)
			      (cdr wanted))
			(loop provided
			      inline
			      (cdr wanted))))))))))

;*---------------------------------------------------------------------*/
;*    get-exported-clauses ...                                         */
;*---------------------------------------------------------------------*/
(define (get-exported-clauses clauses)
   (let loop ((clauses clauses)
	      (export  '())
	      (foreign '())
	      (pragma  '()))
      (cond
	 ((null? clauses)
	  (vector export foreign pragma))
	 ((or (not (pair? clauses)) (not (pair? (car clauses))))
	  (error "get-export-clause" "Illegal clause" clauses))
	 (else
	  (case (car (car clauses))
	     ((use import static with include load force)
	      (loop (cdr clauses) export foreign pragma))
	     ((pragma)
	      (loop (cdr clauses)
		    export
		    foreign
		    (append (cdr (car clauses)) pragma)))
	     ((foreign)
	      (loop (cdr clauses)
		    export
		    (append (cdr (car clauses)) foreign)
		    pragma))
	     ((main)
	      (loop (cdr clauses)
		    (cons `(,(cadr (car clauses)) argv) export)
		    foreign
		    pragma))
	     ((export)
	      (loop (cdr clauses)
		    (append (cdr (car clauses)) export)
		    foreign
		    pragma))
	     (else
	      (error "get-exported-clause" "Illegal module clause"
		     clauses)))))))

;*---------------------------------------------------------------------*/
;*    search-exported ...                                              */
;*    -------------------------------------------------------------    */
;*    On cherche dans la declaration de module si on trouve bien tous  */
;*    ce qu'on a voulu importer.                                       */
;*---------------------------------------------------------------------*/
(define (search-exported wanted provided module)
   (let loop ((provided provided))
      (if (null? provided)
	  #f
	  (let ((pr (car provided)))
	     (let ((name (match-case pr
			    ((inline ?name . ?args)
			     name)
			    ((?name . ?args)
			     name)
			    ((and (not (?- . ?-)) ?name)
			     name)
			    (else
			     (error "search-exported"
				    "Illegal export clause" pr)))))
		(if (eq? name wanted)
		    pr
		    (loop (cdr provided))))))))

