;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Tools/beta.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 24 07:37:36 1993                          */
;*    Last change :  Wed Dec 15 16:26:11 1993 (serrano)                */
;*                                                                     */
;*    Un petit module qui fait de la beta-reduction                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_beta
   (include "Tools/trace.sch")
   (import  tools_shape)
   (export  (beta-reduce dans quoi.par)))

;*---------------------------------------------------------------------*/
;*    beta-reduce ...                                                  */
;*---------------------------------------------------------------------*/
(define (beta-reduce dans quoi.par)
   (trace inline "beta-reduce: " (shape dans) #\Newline
	         "   quoi.par: " (shape quoi.par) #\Newline)
   (let loop ((dans dans))
      (match-case dans
	 (()
	  '())
	 ((atom ?-)
	  (let ((cell (assq dans quoi.par)))
	     (if (pair? cell)
		 (cdr cell)
		 dans)))
	 (('quote . ?-)
	  dans)
	 (else
	  (let liip ((dans dans)
		     (res  '()))
	     (cond
		((null? dans)
		 (reverse! res))
		((not (pair? dans))
		 (reverse! (cons (loop dans) res)))
		(else
		 (liip (cdr dans)
		       (cons (loop (car dans)) res)))))))))
		 
	      
