;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Tools/progn.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 16 18:44:32 1992                          */
;*    Last change :  Wed Mar 17 14:35:56 1993  (serrano)               */
;*                                                                     */
;*    La normalisation des progn                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_progn
   (export (force-progn     body)
	   (normalize-progn body)))

;*---------------------------------------------------------------------*/
;*    normalize-progn ...                                              */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    Cette fonction doit etre utilisee pour normalise du code         */
;*    utilisateur tel qu'il est lu par le lecteur.                     */
;*---------------------------------------------------------------------*/
(define (normalize-progn body)
   (cond
      ((not (pair? body))
       body)
      ((null? (cdr body))
       (car body))
      (else
       `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
				      (cdr body)
				      body)))
		    (if (null? body)
			'()
			(let ((expr (car body)))
			   (if (and (pair? expr) (eq? (car expr) 'begin))
			       (append (cdr expr) (loop (cdr body)))
			       (cons expr (loop (cdr body)))))))))))
 
;*---------------------------------------------------------------------*/
;*    force-progn ...                                                  */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    On force un `begin'. Ceci est utile pour les definitions de      */
;*    fonctions (pour la macro-expansions des fonctions locales).      */
;*---------------------------------------------------------------------*/
(define (force-progn body)
   (cond
      ((not (pair? body))
       `(begin ,body))
      (else
       `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
				      (cdr body)
				      body)))
		    (if (null? body)
			'()
			(let ((expr (car body)))
			   (if (and (pair? expr) (eq? (car expr) 'begin))
			       (append (cdr expr) (loop (cdr body)))
			       (cons expr (loop (cdr body)))))))))))
 
