;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../strings.scm ...                                              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep  8 15:15:07 1993                          */
;*    Last change :  Tue Jan 11 10:48:57 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les fonctions de manipulation de chaines                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_strings
   (export (inline upper-string->symbol s)
	   (write-c-string port string)))

;*---------------------------------------------------------------------*/
;*    upper-string->symbol ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (upper-string->symbol s)
   (string->symbol (string-upcase s)))

;*---------------------------------------------------------------------*/
;*    write-c-string ...                                               */
;*    -------------------------------------------------------------    */
;*    Cette fonction est la copie conforme de la fonction de la        */
;*    librairie `string-for-read'. On peut supprimer cette             */
;*    definition et remplacer ses appels dans le compilo.              */
;*---------------------------------------------------------------------*/
(define (write-c-string port string)
   (write-char #\" port)
   (let ((len (string-length string)))
      (let loop ((r 0))
	 (if (=fx r len)
	     (write-char #\" port)
	     (let ((current-char (string-ref string r)))
		(case (char->integer current-char)
		   ((8);; bask space
		    (write-char #\\ port)
		    (write-char #\b port)
		    (loop (+fx r 1)))
		   ((9);; horizontal tabulation
		    (write-char #\\ port)
		    (write-char #\t port)
		    (loop (+fx r 1)))
		   ((10);; new line
		    (write-char #\\ port)
		    (write-char #\n port)
		    (loop (+fx r 1)))
		   ((11);; vertical tabulation
		    (write-char #\\ port)
		    (write-char #\v port)
		    (loop (+fx r 1)))
		   ((12);; form feed
		    (write-char #\\ port)
		    (write-char #\f port)
		    (loop (+fx r 1)))
		   ((13);; carriage return
		    (write-char #\\ port)
		    (write-char #\r port)
		    (loop (+fx r 1)))
		   ((34);; double-guillemet
		    (write-char #\\ port)
		    (write-char #\" port)
		    (loop (+fx r 1)))
		   ((92);; slash
		    (write-char #\\ port)
		    (write-char #\\ port)
		    (loop (+fx r 1)))
		   (else
		    (let ((num (let ((n (char->integer (string-ref string r))))
				  (if (<fx n 0)
				      (+fx 256 n)
				      n))))
		       (if (or (<fx num (char->integer #\space))
			       (>fx num 126))
			   (let* ((s  (integer->string num 8))
				  (so (substring s 2 (string-length s)))
				  (s0 (make-string (-fx 3 (string-length so))
						   #\0)))
			      (write-char #\\ port)
			      (display s0 port)
			      (display so port))
			   (write-char current-char port))
		       (loop (+fx r 1))))))))))



