;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Write/tree.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 22 16:05:52 1993                          */
;*    Last change :  Thu Apr  8 19:17:36 1993  (serrano)               */
;*                                                                     */
;*    On imprime l'arbre de syntaxe abstraite                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module write_tree
   (include "Var/variable.sch")
   (import  tools_shape
	    tools_file
	    engine_param)
   (export  (write-tree tree)))

;*---------------------------------------------------------------------*/
;*    write-tree ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-tree tree)
   (let* ((output-name (if (string? *dest*)
			   *dest*
			   (if (string? *src*)
			       (string-append (remove-extansion *src*) ".tree")
			       #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-expanded" "Can't open file" output-name)
	  (begin
	     (for-each (lambda (v)
			  (let (args body)
			     (cond
				((global? v)
				 (set! args (function-args (global-value v)))
				 (set! body (function-body (global-value v))))
				((local? v)
				 (if (eq? (local-class v) 'function)
				     (begin
					(set! args (function-args
						    (local-value v)))
					(set! body (function-body
						    (local-value v))))
				     (begin
					(set! args (return-args
						    (local-value v)))
					(set! body (return-body
						    (local-value v)))))))
			     (write (shape `(define ,v
					       (lambda ,args ,body)))
				    port)))
		       tree)
	     (close-output-port port)))))
