;*=====================================================================*/
;*    serrano/prgm/project/bigloo/work/Foreign/rusage.scm ...          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 20 18:17:38 1994                          */
;*    Last change :  Thu Jan 20 18:44:47 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Une utilisation de l'interface etrangere: `rusage'               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rusage
   (foreign (include "sys/time.h")
	    (include "sys/resource.h")
	    (define int RUSAGE_SELF "RUSAGE_SELF")
	    (type timeval  (struct ((long "tv_sec")
				    (long "tv_usec"))
				   "struct timeval"))
	    (type timezone (struct ((int  "tz_minuteswest")
				    (int  "tz_dsttime"))
				   "struct timezone"))
	    (type rusage   (struct ((timeval "ru_utime")
				    (timeval "ru_stime")
				    (int     "ru_maxrss")
				    (int     "ru_ixrss")
				    (int     "ru_idrss")
				    (int     "ru_isrss")
				    (int     "ru_minflt")
				    (int     "ru_majflt")
				    (int     "ru_nswap")
				    (int     "ru_inblock")
				    (int     "ru_oublock")
				    (int     "ru_msgsnd")
				    (int     "ru_msgrcv")
				    (int     "ru_nsignals")
				    (int     "ru_nvcsw")
				    (int     "ru_nivcsw"))
				   "struct rusage"))
	    (int getrusage (int rusage*) "getrusage")))

(define r (make-rusage))
(define i1 (getrusage RUSAGE_SELF r))

(define (print-time-val t)
   (print "{tv_sec: " (timeval-tv_sec t)
	  ", tv_usec: " (timeval-tv_usec t) "}"))

(print-time-val (rusage-ru_utime r))

(define (interval n)
   (if (=fx n 0)
       '()
       (cons n (interval (-fx n 1)))))

(define (f n)
   (let loop ((i 1))
      (if (=fx i n)
	  'done
	  (begin
	     (interval 10000)
	     (loop (+fx i 1)))))
   (let ((l (interval 10000)))
      l))

(let ((n (if (pair? (cdr (command-line)))
	     (string->integer (cadr (command-line)))
	     11)))
   (f n))

(define i2 (getrusage RUSAGE_SELF r))

(print-time-val (rusage-ru_utime r))

(newline)



   


   
