;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/exit.scm ...                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 12 10:06:03 1992                          */
;*    Last change :  Mon Jan  4 19:01:05 1993  (serrano)               */
;*                                                                     */
;*    On test les trois sortes de `bind-exit'                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module bind-exit
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-bind-exit)))

;*---------------------------------------------------------------------*/
;*    test0 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test0 n)
   (+ n
      (bind-exit (out)
	     (labels ((loop (m)
			    (if (= m 0)
				(out 1)
				(loop (- m 1)))))
		(loop n)
		2))))

;*---------------------------------------------------------------------*/
;*    test1                                                            */
;*---------------------------------------------------------------------*/
(define (test1 . l)
   (bind-exit (error)
	  (labels ((sum (l)
			(if (null? l)
			    0
			    (if (integer? (car l))
				(+ (car l) (sum (cdr l)))
				(error -1)))))
	     (sum l))))

;*---------------------------------------------------------------------*/
;*    test2                                                            */
;*---------------------------------------------------------------------*/
(define (call-with-current-continuation f)
   (bind-exit (c) (f c)))

(define test2 (lambda l
	       (call-with-current-continuation
		(lambda (error)
		   (labels ((sum (l)
				 (if (null? l)
				     0
				     (if (integer? (car l))
					 (+ (car l) (sum (cdr l)))
					 (error -1)))))
		      (sum l))))))

;*---------------------------------------------------------------------*/
;*    test3                                                            */
;*---------------------------------------------------------------------*/
(define (test3 x)
   (bind-exit (jump)
	  (labels ((foo (x) x))
	     (let ((old-jump jump))
		(set! jump foo)
		(jump x)
		(old-jump -1)
		(foo 3)))))

;*---------------------------------------------------------------------*/
;*    test4 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test4 f)
   (let ((kapture 1))
      (bind-exit (c) (f kapture c))))

;*---------------------------------------------------------------------*/
;*    test-bind-exit ...                                               */
;*---------------------------------------------------------------------*/
(define (test-bind-exit)
   (test-module "bind-exit" "bind-exit.scm" #t)
   (test "goto bind-exit" (test0 4) 5)
   (test "simple bind-exit" (test1 1 2 4) 7)
   (test "simple bind-exit" (test1 1 'toto 4) -1)
   (test "call-with-current-continuation" (test2 1 2 4) 7)
   (test "call-with-current-continuation" (test2 1 'toto 4) -1)
   (test "set! bind-exit" (test3 7) -1)
   (test "kapture bind-exit" (test4 (lambda (x y) x)) 1))
		 
	 
