;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Ieee/ports.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jul  5 11:22:32 1992                          */
;*    Last change :  Thu Dec 23 12:18:42 1993 (serrano)                */
;*                                                                     */
;*    6.10.1 Ports (page 29, r4)                                       */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_ports_6_10_1
   (foreign (define bool  c-input-port?  (obj)  "INPUT_PORTP")
	    (define bool  c-output-port? (obj)  "OUTPUT_PORTP")
	    (boutput-port c-current-output-port "current_output_port")
	    (boutput-port c-current-error-port  "current_error_port")
	    (binput-port  c-current-input-port  "current_input_port")
	    (obj          c-open-input-file (bstring bint) "open_input_file")
	    (obj          c-open-input-string (obj)  "open_input_string")
	    (obj          c-open-output-file  (obj)  "open_output_file")
	    (obj          c-open-output-string ()    "open_output_string")
	    (obj          c-close-input-port  (obj)  "close_input_port")
	    (obj          c-close-output-port (obj)  "close_output_port")
	    (obj          c-default-io-bufsiz        "default_io_bufsiz")
	    (bool         reset-eof            (obj)  "reset_eof")
	    (obj          c-append-output-file (obj) "append_output_file")
	    (define obj c-flush-output-port (boutput-port) "FLUSH_OUTPUT_PORT")
	    (bool       c-fexists?           (string)        "fexists")
	    (bool       c-delete-file        (string)        "unlink")
	    (int        c-rename-file        (string string) "rename"))
   (export  (call-with-input-file string proc)
	    (call-with-output-file string proc)
            (inline input-port?  obj)
	    (inline output-port? obj)
	    (inline current-input-port) 
	    (inline current-error-port)
	    (inline current-output-port)
	    (with-input-from-file string thunk)
	    (with-output-to-file string thunk)
	    (open-input-file string . bufsiz)
	    (inline open-input-string string)
	    (inline open-output-file string)
	    (inline open-output-string)
	    (inline close-input-port port)
	    (inline close-output-port port)
	    (inline flush-output-port port)
	    (inline file-exists? name)
	    (inline append-output-file string)
	    (inline delete-file string)
	    (inline rename-file string string)))

;*---------------------------------------------------------------------*/
;*    call-with-input-file ...                                         */
;*---------------------------------------------------------------------*/
(define (call-with-input-file string proc)
   (let ((port (open-input-file string)))
      (if (input-port? port)
	  (let ((res (proc port)))
	     (close-input-port port)
	     res)
	  (error "call-with-input-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    call-with-output-file ...                                        */
;*---------------------------------------------------------------------*/
(define (call-with-output-file string proc) 
   (let ((port (open-output-file string)))
      (if (output-port? port)
	  (let ((res (proc port)))
	     (close-output-port port)
	     res)
	  (error "call-with-output-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    input-port? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (input-port? obj)
   (c-input-port? obj))

;*---------------------------------------------------------------------*/
;*    output-port? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (output-port? obj)
   (c-output-port? obj))

;*---------------------------------------------------------------------*/
;*    current-input-port ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (current-input-port)
   c-current-input-port)

;*---------------------------------------------------------------------*/
;*    current-output-port ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (current-output-port)
   c-current-output-port)

;*---------------------------------------------------------------------*/
;*    current-error-port ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (current-error-port)
   c-current-error-port)

;*---------------------------------------------------------------------*/
;*    with-input-from-file ...                                         */
;*---------------------------------------------------------------------*/
(define (with-input-from-file string thunk)
   (let ((port (open-input-file string)))
      (if (input-port? port)
	  (let ((old-input-port (current-input-port))
		(result         '()))
	     (set! c-current-input-port port)
	     (set! result (thunk))
	     (close-input-port port)
	     (set! c-current-input-port old-input-port)
	     result)
	  (error "with-input-from-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    with-output-to-file ...                                          */
;*---------------------------------------------------------------------*/
(define (with-output-to-file string thunk)
   (let ((port (open-output-file string)))
      (if (output-port? port)
	  (let ((old-output-port (current-output-port))
		(result         '()))
	     (set! c-current-output-port port)
	     (set! result (thunk))
	     (close-output-port port)
	     (set! c-current-output-port old-output-port)
	     result)
	  (error "with-output-to-file" "can't open file" string))))

;*---------------------------------------------------------------------*/
;*    open-input-file ...                                              */
;*---------------------------------------------------------------------*/
(define (open-input-file string . bufsiz)
   (let ((size (if (null? bufsiz)
		   c-default-io-bufsiz
		   (car bufsiz))))
      (if (not (integer? size))
	  (error "open-input-file" "not a number" size)
	  (c-open-input-file string size))))

;*---------------------------------------------------------------------*/
;*    open-input-string ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (open-input-string string)
   (c-open-input-string string))

;*---------------------------------------------------------------------*/
;*    open-output-file ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (open-output-file string)
   (c-open-output-file string))

;*---------------------------------------------------------------------*/
;*    open-output-string ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (open-output-string)
   (c-open-output-string))

;*---------------------------------------------------------------------*/
;*    close-input-port ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (close-input-port port)
   (c-close-input-port port))

;*---------------------------------------------------------------------*/
;*    close-output-port ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (close-output-port port)
   (c-close-output-port port))

;*---------------------------------------------------------------------*/
;*    Les fonctions qui suivent ne sont pas r4                         */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    flush-output-port ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (flush-output-port port)
   (c-flush-output-port port))

;*---------------------------------------------------------------------*/
;*    file-exists? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (file-exists? name)
   (c-fexists? name))
   
;*---------------------------------------------------------------------*/
;*    append-output-file ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (append-output-file string)
   (c-append-output-file string))

;*---------------------------------------------------------------------*/
;*    delete-file ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (delete-file string)
   (c-delete-file string))

;*---------------------------------------------------------------------*/
;*    rename-file ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (rename-file string1 string2)
   (if (eq? (c-rename-file string1 string2) 0)
       #t
       #f))
