;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Llib/error.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 11 13:18:15 1992                          */
;*    Last change :  Sun Feb 13 09:43:08 1994 (serrano)                */
;*                                                                     */
;*    La gestion `runtime' des erreurs                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __error
   (foreign (obj c-exit (bint)                        "bigloo_exit")
	    (include "signal.h")
	    (define obj push-lambda-trace (obj)       "PUSH_LAMBDA_TRACE")
	    (define obj pop-lambda-trace  (obj)       "POP_LAMBDA_TRACE")
	    (define obj c-get-lambda-stack  ()        "GET_LAMBDA_STACK")
	    (define obj c-set-lambda-stack! (obj)     "SET_LAMBDA_STACK")
	    (obj        c-dump-lambda-stack (obj int) "dump_lambda_stack") 
	    (define int sigfpe                        "SIGFPE")
	    (define int sigill                        "SIGILL")
	    (define int sigbus                        "SIGBUS")
	    (define int sigsegv                       "SIGSEGV")
	    (export obj the_failure (obj obj obj)     "the_failure"))
   (export  (inline exit num)
	    (failure proc message object)
	    (the_failure proc message object)
            (add-error-handler! handler escape)
	    (remove-error-handler!)
	    (inline error proc message object)
	    (notify-error proc mes obj)
	    (type-error type name)
	    (inline get-lambda-stack)
	    (inline set-lambda-stack! obj)
	    (inline dump-lambda-stack . depth))
   (static  *error-handler*
	    (default-error-handler proc mes obj)
	    (incorrect-error-handler handler))
   (pragma  (type-error _imbricable_))) 

;*---------------------------------------------------------------------*/
;*    get-lambda-stack ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (get-lambda-stack)
   (c-get-lambda-stack))

;*---------------------------------------------------------------------*/
;*    set-lambda-stack! ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (set-lambda-stack! obj)
   (c-set-lambda-stack! obj))

;*---------------------------------------------------------------------*/
;*    exit ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (exit n)
   (c-exit n))

;*---------------------------------------------------------------------*/
;*    La valeur par defaut du *error-handler*                          */
;*---------------------------------------------------------------------*/
(define *error-handler* '())

;*---------------------------------------------------------------------*/
;*    dump-lambda-stack ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (dump-lambda-stack . depth)
   (let ((depth (if (or (null? depth) (not (integer? (car depth))))
		    10
		    (car depth))))
      (c-dump-lambda-stack (current-error-port) depth)))
					       
;*---------------------------------------------------------------------*/
;*    add-error-handler! ...                                           */
;*---------------------------------------------------------------------*/
(define (add-error-handler! handler escape)
   (set! *error-handler* (cons (cons handler escape) *error-handler*)))

;*---------------------------------------------------------------------*/
;*    remove-error-handler! ...                                        */
;*---------------------------------------------------------------------*/
(define (remove-error-handler!)
   (if (pair? *error-handler*)
       (set! *error-handler* (cdr *error-handler*)))
   *error-handler*)

;*---------------------------------------------------------------------*/
;*    failure ...                                                      */
;*---------------------------------------------------------------------*/
(define (failure proc message object)
   (failure proc message object))

;*---------------------------------------------------------------------*/
;*    error ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (error proc message object)
   (failure proc message object))
   
;*---------------------------------------------------------------------*/
;*    the_failure ...                                                  */
;*---------------------------------------------------------------------*/
(define (the_failure proc message object)
   (reader-reset!)
   (if (null? *error-handler*)
       (default-error-handler proc message object)
       (let ((handler (car (car *error-handler*)))
	     (escape  (cdr (car *error-handler*))))
	  (remove-error-handler!)
	  (if (and (procedure? handler)
		   (=fx (procedure-arity handler) 4))
	      (handler escape proc message object)
	      (incorrect-error-handler handler)))))

;*---------------------------------------------------------------------*/
;*    notify-error ...                                                 */
;*---------------------------------------------------------------------*/
(define (notify-error proc mes obj)
   (newline (current-output-port))
   (newline (current-error-port))
   (display "*** ERROR:bigloo:" (current-error-port))
   (fprint (current-error-port) proc ":" #\Newline mes " -- " obj))

;*---------------------------------------------------------------------*/
;*    type-error ...                                                   */
;*---------------------------------------------------------------------*/
(define (type-error type name)
   (let ((type-string (symbol->string type)))
      (string-append "type `" type-string
		     "' expected for variable " (symbol->string name))))
   
;*---------------------------------------------------------------------*/
;*    default-error-handler ...                                        */
;*---------------------------------------------------------------------*/
(define (default-error-handler proc mes obj) 
   (notify-error proc mes obj)
   (dump-lambda-stack)
   (c-exit -1)
   -1)

;*---------------------------------------------------------------------*/
;*    incorrect-error-handler ...                                      */
;*---------------------------------------------------------------------*/
(define (incorrect-error-handler handler)
   (default-error-handler "error" "Not an error handler" handler))

;*---------------------------------------------------------------------*/
;*    sigfpe-error-handler ...                                         */
;*---------------------------------------------------------------------*/
(define (sigfpe-error-handler n)
   (error "arithmetic procedure" "`floating point' exception" "reached"))

;*---------------------------------------------------------------------*/
;*    sigill-error-handler ...                                         */
;*---------------------------------------------------------------------*/
(define (sigill-error-handler n)
   (error "bigloo" "`illegal instruction' exception" "reached"))

;*---------------------------------------------------------------------*/
;*    sigbus-error-handler ...                                         */
;*---------------------------------------------------------------------*/
(define (sigbus-error-handler n)
   (error "bigloo" "`bus error' exception" "reached"))

;*---------------------------------------------------------------------*/
;*    sigsegv-error-handler ...                                        */
;*---------------------------------------------------------------------*/
(define (sigsegv-error-handler n)
   (error "bigloo" "`segmentation violation' exception" "reached"))

;*---------------------------------------------------------------------*/
;*    On installe le ratrappage des exceptions                         */
;*---------------------------------------------------------------------*/
(signal sigfpe  sigfpe-error-handler)
(signal sigill  sigill-error-handler)
(signal sigbus  sigbus-error-handler)
(signal sigsegv sigsegv-error-handler)
