;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.2/Llib/expd-do.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Sep 28 16:06:31 1992                          */
;*    Last change :  Wed Apr 28 11:13:22 1993  (serrano)               */
;*                                                                     */
;*    La macro `DO'                                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_do
   (export (expand-eval-do x e)))

;*---------------------------------------------------------------------*/
;*    gen-doloop-name ...                                              */
;*---------------------------------------------------------------------*/
(define gen-doloop-name
   (let ((num -1))
      (lambda ()
	 (set! num (+fx 1 num))
	 (string->symbol (string-append "do-loop--" (integer->string num))))))

;*---------------------------------------------------------------------*/
;*    expand-do ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-eval-do exp e)
   (match-case exp
      ((?- ?bindings ?end . ?command)
       (let* ((let-bindings  bindings)
	      (vars 	   '())
	      (inits 	   '())
	      (steps 	   '())
 	      (loop	    (gen-doloop-name))
	      (test	    (if (pair? end)
		 		(car end)
				(error "do" "Illegal form" exp)))
	      (ending       (if (null? (cdr end))
				(list #f)
				(cdr end)))
	      (body         command))
	  (for-each
	   (lambda (var-init-step)
	      (if (and (>=fx (length var-init-step) 2)
		       (<=fx (length var-init-step) 3))
		  (let* ((var (car var-init-step))
			 (init (cadr var-init-step))
			 (step (if (not (null? (cddr var-init-step)))
				   (car (cddr var-init-step))
				   var)))
		     (set! vars  (cons var vars))
		     (set! steps (cons step steps))
		     (set! inits (cons init inits)))
		  (error 'do "Illegal form:" var-init-step)))
	   (reverse let-bindings))
	  (e `(letrec ((,loop (lambda ,vars
				 (if ,test
				     (begin ,@ending)
				     (begin ,@body
					    (,loop ,@steps))))))
		 (,loop ,@inits))
	     e)))
      (else
       (error 'do "Illegal form" 'exp))))

