;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.5/Llib/expd-let.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  4 17:10:13 1993                          */
;*    Last change :  Thu Oct 14 15:44:07 1993 (serrano)                */
;*                                                                     */
;*    Les expanseurs des formes `let's                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_let
   (import (__expander "Llib/expander.scm"))   
   (export (expand-eval-let             x e)
	   (expand-eval-let*            x e)
	   (expand-eval-letrec          x e)
	   (expand-eval-labels          x e)))

;*---------------------------------------------------------------------*/
;*    expand-eval-let ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-eval-let x e)
   (match-case x
      ((?- () . ?body)
       (e `((lambda () ,(normalize-progn body))) e))
      ((?- (and (not (?- . ?-)) ?loop) ?bindings . ?body)
       (e `(letrec ((,loop (lambda ,(map (lambda (b)
					    (if (pair? b)
						(car b)
						b))
					 bindings)
			      ,(normalize-progn body))))
	      (,loop ,@(map (lambda (b)
			       (if (pair? b)
				   (cadr b)
				   '(unspecified)))
			    bindings)))
	  e))
      ((?- ?bindings . ?body)
       (let ((body      (normalize-progn body))
	     (vars.vals (let loop ((bindings bindings)
				   (vars     '())
				   (vals     '()))
			   (cond
			      ((null? bindings)
			       (cons vars vals))
			      ((not (pair? (car bindings)))
			       (loop (cdr bindings)
				     (cons (car bindings) vars)
				     (cons '(unspecified) vals)))
			      (else
			       (loop (cdr bindings)
				     (cons (car (car bindings)) vars)
				     (cons (normalize-progn
					    (cdr (car bindings)))
					   vals)))))))
	  (e `((lambda ,(car vars.vals) ,body) ,@(cdr vars.vals)) e)))
      (else
       (error "expand-let" "Illegal form" x))))
	   
;*---------------------------------------------------------------------*/
;*    expand-eval-let* ...                                             */
;*---------------------------------------------------------------------*/
(define (expand-eval-let* x e)
   (match-case x
      ((?- () . ?body)
       (e `((lambda () ,(normalize-progn body))) e))
      ((?- ?bindings . ?body)
       (e `(let (,(car bindings))
	      (let* ,(cdr bindings)
		 ,(normalize-progn body))) e))
      (else
       (error "expand-let*" "Illegal form" x))))
   
;*---------------------------------------------------------------------*/
;*    expand-eval-letrec ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-eval-letrec x e)
   (match-case x
      ((?- ?bindings . ?body)
       (let ((body      (normalize-progn body))
	     (vars.vals (let loop ((bindings bindings)
				   (vars     '())
				   (vals     '()))
			   (cond
			      ((null? bindings)
			       (cons vars vals))
			      ((not (pair? (car bindings)))
			       (error "letrec" "Illegal form" x))
			      (else
			       (loop (cdr bindings)
				     (cons (car (car bindings)) vars)
				     (cons (normalize-progn
					    (cdr (car bindings)))
					   vals)))))))
	  (e `((lambda ,(car vars.vals)
	       ,(normalize-progn
		 (let loop ((vars (car vars.vals))
			    (vals (cdr vars.vals))
			    (res  (list body)))
		    (if (null? vars)
			res
			(loop (cdr vars)
			      (cdr vals)
			      (cons `(set! ,(car vars)
					   ,(car vals))
				    res))))))
	    ,@(map (lambda (v) '(unspecified)) bindings)) e)))
      (else
       (error "letrec" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    expand-eval-labels ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-eval-labels x e)
   (match-case x
      ((?- () . ?body)
       (e `((lambda () ,(normalize-progn body))) e))
      ((?- ?bindings . ?body)
       (let ((new (let loop ((bindings bindings))
		     (cond
			((null? bindings)
			 '())
			((not (pair? bindings))
			 (error "expand-labels" "Illegal form" x))
			(else
			 (match-case (car bindings)
			    ((?name ?args . ?lbody)
			     (cons `(,name (lambda ,args ,@lbody))
				   (loop (cdr bindings))))
			    (else
			     (error "expand-labels" "Illegal form" x))))))))
	  (e `(letrec ,new ,@body) e)))
      (else
       (error "expand-labels" "Illegal form" x))))
