;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.6/Llib/intext.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 18 08:11:58 1994                          */
;*    Last change :  Sun Jan 23 13:11:01 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'internement et l'externement lineaire.                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __intext
   (foreign (define bool cnst?         (obj) "CNSTP")
	    (define int  cnst->integer (obj) "CCNST")
	    (define obj  integer->cnst (int) "BCNST")
	    (define bool pointer?      (obj) "POINTERP"))
   (export  (string->obj str)
	    (obj->string obj)))

;*---------------------------------------------------------------------*/
;*    for  ....                                                        */
;*---------------------------------------------------------------------*/
(define-macro (for var min max . body)
   (let ((loop (gensym)))
      `(let ,loop ((,var ,min))
	    (if (<=fx ,var ,max)
		(begin
		   ,@body
		   (,loop (+fx ,var 1)))
		'done))))

;*---------------------------------------------------------------------*/
;*    Les variables de controle de `string->obj'                       */
;*---------------------------------------------------------------------*/
(define *ref-vector* '#())
(define *defining*    #f)
(define *pointeur*    0)
(define *nb-ref*      0)
(define *ref*         0)

;*---------------------------------------------------------------------*/
;*    Cette variable est *indispensable* pour la fonction `mark-item!' */
;*    (voir commentaire dans la fonction).                             */
;*---------------------------------------------------------------------*/
(define *string-mark* '())

;*---------------------------------------------------------------------*/
;*    string->obj ...                                                  */
;*---------------------------------------------------------------------*/
(define (string->obj s)
   (define (read-taille)
      (let ((accu-entier 0))
	 (let ((taille (char->integer (string-ref s *pointeur*))))
	    (set! *pointeur* (+fx *pointeur* 1))
	    (for i 0 (-fx taille 1)
		 (let ((d (string-ref s *pointeur*)))
		    (set! accu-entier (+fx (*fx 256 accu-entier)
					   (char->integer d)))
		    (set! *pointeur* (+fx *pointeur* 1))))
	    accu-entier)))
   (define (read-nombre-entier)
      (read-taille))
   (define (read-nombre-flottant)
      (let* ((taille (read-taille))
	     (res    (string->real (substring s *pointeur* (+fx *pointeur*
							      taille)))))
	 (set! *pointeur* (+fx *pointeur* taille))
	 res))
   (define (read-definition)
      (set! *defining* (read-item))
      (read-item))
   (define (read-reference)
      (vector-ref *ref-vector* (read-item)))
   (define (read-symbol)
      (string->symbol (read-string)))
   (define (read-cnst)
      (integer->cnst (read-nombre-entier)))
   (define (read-string)
      (let* ((taille (read-taille))
	     (res    (substring s *pointeur* (+fx *pointeur* taille))))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (set! *pointeur* (+fx *pointeur* taille))
	 res))
   (define (read-vecteur)
      (let* ((taille (read-taille))
	     (res    (make-vector taille)))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (vector-set! res i (read-item)))
	 res))
   (define (read-vecteur-tague)
      (let* ((tag    (read-item))
	     (taille (read-taille))
	     (res    (make-vector taille)))
	 (vector-tag-set! res tag)
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (vector-set! res i (read-item)))
	 res))
   (define (read-liste)
      (let* ((taille (read-taille))
	     (res    (cons '() '())))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (let loop ((i  0)
		    (hd res))
	    (if (=fx i (-fx taille 2))
		(begin
		   (set-car! hd (read-item))
		   (set-cdr! hd (read-item)))
		(begin
		   (set-car! hd (read-item))
		   (set-cdr! hd (cons '() '()))
		   (loop (+fx i 1) (cdr hd)))))
	 res))
   (define (read-structure)
      (let* ((taille (read-taille))
	     (key    (read-item))
	     (res    (make-struct key taille (unspecified))))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (struct-set! res i (read-item)))
	 res)) 
   (define (read-item)
      (let ((d (string-ref s *pointeur*)))
	 (set! *pointeur* (+fx *pointeur* 1))
	 (case d
	    ((#\=)  (read-definition))
	    ((#\#)  (read-reference))
	    ((#\')  (read-symbol))
	    ((#\<)  (read-cnst))
	    ((#\")  (read-string))
	    ((#\[)  (read-vecteur))
	    ((#\t)  (read-vecteur-tague))
	    ((#\()  (read-liste))
	    ((#\{)  (read-structure))
	    ((#\f)  (read-nombre-flottant))
	    ((#\-)  (negfx (read-nombre-entier)))
	    (else   (set! *pointeur* (-fx *pointeur* 1))
		    (read-nombre-entier)))))
   (set! *pointeur* 0)
   (let ((d (string-ref s *pointeur*)))
      (if (char=? d #\c)
	  (begin
	     (set! *pointeur* (+fx *pointeur* 1))
	     (set! *ref-vector* (make-vector (read-taille))))))
   (read-item))

;*---------------------------------------------------------------------*/
;*    les structures de marks                                          */
;*---------------------------------------------------------------------*/
(define-struct mark obj old-value ref defined? ref-count)

;*---------------------------------------------------------------------*/
;*    incr-mark-ref-count! ...                                         */
;*---------------------------------------------------------------------*/
(define (incr-mark-ref-count! mark ref)
   (let ((old-mark (mark-ref-count mark)))
      (mark-ref-count-set! mark (+fx 1 old-mark))
      (if (=fx old-mark 0)
	  (+fx ref 1)
	  ref)))

;*---------------------------------------------------------------------*/
;*    pair-unmark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (pair-unmark! pair)
   (let ((old-value (mark-old-value (get-pair-mark pair))))
      (set-cdr! pair old-value)))

;*---------------------------------------------------------------------*/
;*    pair-mark! ...                                                   */
;*---------------------------------------------------------------------*/
(define (pair-mark! pair)
   (let ((new (make-mark)))
      (mark-obj-set!       new pair)
      (mark-old-value-set! new (cdr pair))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (set-cdr! pair new)
      new))

;*---------------------------------------------------------------------*/
;*    pair-marked? ...                                                 */
;*---------------------------------------------------------------------*/
(define (pair-marked? pair)
   (mark? (cdr pair)))

;*---------------------------------------------------------------------*/
;*    get-pair-mark ...                                                */
;*---------------------------------------------------------------------*/
(define (get-pair-mark pair)
   (cdr pair))

;*---------------------------------------------------------------------*/
;*    pointer-unmark! ...                                              */
;*---------------------------------------------------------------------*/
(define (pointer-unmark! ptr)
   (let ((old-value (mark-old-value (get-pointer-mark ptr))))
      (poke! ptr 1 old-value)))

;*---------------------------------------------------------------------*/
;*    pointer-mark! ...                                                */
;*---------------------------------------------------------------------*/
(define (pointer-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (peek ptr 1))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (poke! ptr 1 new)
      new))

;*---------------------------------------------------------------------*/
;*    pointer-marked? ...                                              */
;*---------------------------------------------------------------------*/
(define (pointer-marked? ptr)
   (mark? (get-pointer-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-pointer-mark ...                                             */
;*---------------------------------------------------------------------*/
(define (get-pointer-mark ptr)
   (peek ptr 1))

;*---------------------------------------------------------------------*/
;*    *taille-du-mot* ...                                              */
;*---------------------------------------------------------------------*/
(define *taille-du-mot* 4)

;*---------------------------------------------------------------------*/
;*    obj->string ...                                                  */
;*---------------------------------------------------------------------*/
(define (obj->string obj)
   (set! *ref*      -1)
   (set! *nb-ref*    0)
   (set! *pointeur*  0)
   (let* ((length-buffer    100)
	  (buffer            (make-string length-buffer #\space)))
      (define (get-new-ref)
	 (set! *ref* (+fx *ref* 1))
	 *ref*)
      (define (verifie-taille-buffer! taille)
	 (let ((l (+fx *pointeur* (+fx taille (+fx *taille-du-mot* 1)))))
	    (if (>=fx l length-buffer)
		(begin
		   (let ((vieille-longeur length-buffer)
			 (vieux-buffer    buffer))
		      (set! length-buffer (*fx 2 (+fx l 100)))
		      (set! buffer (make-string length-buffer))
		      (blit-string! vieux-buffer 0 buffer
				    0 vieille-longeur))))))
      (define (print-marqueur c)
	 (string-set! buffer *pointeur* c)
	 (set! *pointeur* (+fx *pointeur* 1)))
      (define (print-int-as-char c)
	 (print-marqueur (integer->char c)))
      (define (print-mot m)
	 (let ((nombre-nul #t))
	    (let loop ((i (-fx *taille-du-mot* 1)))
	       (if (=fx i -1)
		   'done
		   (begin
		      (let ((d (bit-and (bit-rsh m (*fx 8 i)) #xff)))
			 (if (and (not (=fx d 0)) nombre-nul)
			     (begin
				(set! nombre-nul #f)
				(print-int-as-char (+fx i 1))
				(print-int-as-char d))
			     (begin
				(if (not nombre-nul)
				    (print-int-as-char d)))))
		      (loop (-fx i 1)))))
	    (if nombre-nul
		(print-int-as-char 0))))
      (define (print-taille taille)
	 (verifie-taille-buffer! taille)
	 (print-mot taille))
      (define (print-chars s len)
	 (let ((taille len))
	    (print-taille taille)
	    (blit-string! s 0 buffer *pointeur* taille)
	    (set! *pointeur* (+fx *pointeur* taille))))
      (define (print-ds s len)
	 (print-chars s len))
      (define (print-df f)
	 (let ((s (real->string f)))
	    (print-chars s (string-length s))))
      (define (print-di i)
	 (verifie-taille-buffer! 0)
	 (if (<fx i 0)
	     (begin
		(string-set! buffer *pointeur* #\-)
		(set! *pointeur* (+fx *pointeur* 1))
		(print-mot (negfx i)))
	     (print-mot i)))
      (define (print-dv v len)
	 (print-taille len)
	 (for i 0 (-fx len 1)
	      (print-item (vector-ref-ur v i))))
      (define (pair-mark-gc! p)
	 (let ((mark (get-pair-mark p)))
 	    (if (and (mark-defined? mark)
		     (>fx (mark-ref-count mark) 0))
		(mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
		(pair-unmark! p))))
      (define (print-dl p len)
	 (print-taille len)
	 (let loop ((i 0)
		    (p p))
	    (cond
	       ((=fx i (-fx len 1))
		(if (pair? p)
		    (begin
		       (print-item (car p))
		       (print-item '())
		       (pair-mark-gc! p))
		    (print-item p)))
	       (else
		(let* ((mark (get-pair-mark p))
		       (vcdr (mark-old-value mark)))
		   (print-item (car p))
		   (pair-mark-gc! p)
		   (if (and (pair? vcdr)
			    (let ((mark (get-pair-mark vcdr)))
			       (or (> (mark-ref-count mark) 0)
				   (mark-defined? mark))))
		       (print-item vcdr)
		       (loop (+fx i 1) vcdr)))))))
      (define (print-item item)
	 (cond
	    ((symbol? item)
	     (print-marqueur #\')
	     (let ((s (symbol->string item)))
		(print-ds s (string-length s))))
	    ((cnst? item)
	     (print-marqueur #\<)
	     (print-di (cnst->integer item)))
	    ((integer? item)
	     (print-di item))
	    ((real? item)
	     (print-marqueur #\f)
	     (print-df item))
	    ((string? item)
	     (cond
		((mark-defined? (get-pointer-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-pointer-mark item)))
		 (mark-ref-count-set! (get-pointer-mark item)
				      (-fx (mark-ref-count
					    (get-pointer-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-pointer-mark item)) 0)
		     (pointer-unmark! item)))
		((=fx (mark-ref-count (get-pointer-mark item)) 0)
		 (pointer-unmark! item)
		 (print-marqueur #\")
		 (print-ds item (string-length item)))
		(else
		 (let ((ref  (get-new-ref))
		       (mark (get-pointer-mark item)))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\")
		    (print-ds item (mark-old-value mark))))))
	    ((pair? item)
	     (cond
		((mark-defined? (get-pair-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-pair-mark item)))
		 (pair-mark-gc! item))
		((=fx (mark-ref-count (get-pair-mark item)) 0)
		 (let ((len (marked-pair-length item)))
		    (print-marqueur #\()
		    (mark-defined?-set! (get-pair-mark item) #t)
		    (print-dl item len)))
		(else
		 (let ((ref  (get-new-ref))
		       (mark (get-pair-mark item))
		       (len  (marked-pair-length item)))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\()
		    (print-dl item len)))))
	    ((vector? item)
	     (cond
		((mark-defined? (get-pointer-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-pointer-mark item)))
		 (mark-ref-count-set! (get-pointer-mark item)
				      (-fx (mark-ref-count
					    (get-pointer-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-pointer-mark item)) 0)
		     (pointer-unmark! item)))
		((=fx (mark-ref-count (get-pointer-mark item)) 0)
		 (pointer-unmark! item)
		 (let ((tag (vector-tag item)))
		    (if (>fx tag 0)
			(begin
			   (print-marqueur #\t)
			   (print-di tag)
			   (print-dv item (vector-length item)))
			(begin
			   (print-marqueur #\[)
			   (print-dv item (vector-length item))))))
		(else
		 (let* ((ref  (get-new-ref))
			(mark (get-pointer-mark item))
			tag
			len) 
		    (begin
		       ;; il faut momentanement restorer le vecteur
		       (poke! item 1 (mark-old-value mark))
		       (set! tag (vector-tag item))
		       (set! len (vector-length item))
		       ;; on restore
		       (poke! item 1 mark))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (if (>fx tag 0)
			(begin
			   (print-marqueur #\t)
			   (print-di tag)
			   (print-dv item len))
			(begin
			   (print-marqueur #\[)
			   (print-dv item len)))))))))
      (set! *string-mark* '())
      (mark-item! obj)
      (set! *pointeur* 0)
      (if (>fx *nb-ref* 0)
	  (begin
	     (print-marqueur #\c)
	     (print-di *nb-ref*)))
      (print-item obj)
      (set! *string-mark* '())
      (substring buffer 0 *pointeur*)))

;*---------------------------------------------------------------------*/
;*    mark-item! ...                                                   */
;*---------------------------------------------------------------------*/
(define (mark-item! obj)
   (let loop ((obj obj))
      (cond
	 ((pair? obj)
	  (if (pair-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-pair-mark obj)
						   *nb-ref*))
	      (let ((ocar (car obj))
		    (ocdr (cdr obj)))
		 ;; on marque la paire
		 (pair-mark! obj)
		 ;; on l'ecrit
		 (loop ocar)
		 (loop ocdr))))
	 ((not (pointer? obj))
	  'done)
	 ((pointer-marked? obj) 
	  (set! *nb-ref* (incr-mark-ref-count! (get-pointer-mark obj)
					       *nb-ref*)))
	 ((string? obj)
;*---------------------------------------------------------------------*/
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    Attention, il faut faire tres attention, les chaines sont        */
;*    allouees de telle facon que le GC sait qu'il n'y a pas de        */
;*    ptr dedans ! Il faut donc bien attention a ce que les marks      */
;*    (des chaines) soient mises dans une listes pour qu'elles ne      */
;*    soient pas ramassees.                                            */
;*---------------------------------------------------------------------*/
	  (pointer-mark! obj)
	  (set! *string-mark* (cons (get-pointer-mark obj) *string-mark*)))
	 ((vector? obj)
	  (let ((len (vector-length obj))
		(tag (vector-tag obj)))
	     (pointer-mark! obj)
	     (let liip ((i 0))
		(if (=fx i len)
		    'done
		    (begin
		       (loop (vector-ref-ur obj i))
		       (liip (+fx i 1)))))))
	 ((struct? obj)
	  (let ((key (struct-key obj))
		(len (struct-length obj)))
	     ;; on marque la structure
	     (pointer-mark! obj)
	     (let liip ((i 0))
		(if (=fx i len)
		    'done
		    (begin
		       (loop (struct-ref obj i))
		       (liip (+fx i 1)))))))
	 (else
	  'done))))

;*---------------------------------------------------------------------*/
;*    marked-pair-length ...                                           */
;*---------------------------------------------------------------------*/
(define (marked-pair-length l)
   (let loop ((l l)
	      (r 1))
      (let* ((mark (get-pair-mark l))
	     (vcdr (mark-old-value mark)))
	 (if (pair? vcdr)
	     (let ((mark (get-pair-mark vcdr)))
		(if (or (> (mark-ref-count mark) 0)
			(mark-defined? mark))
		    (+fx r 1)
		    (loop vcdr (+fx r 1))))
	     (+fx r 1)))))

      
	 
   
   


     
      
      
   
		


