;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Llib/rgc.scm ...          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug  4 16:41:45 1992                          */
;*    Last change :  Wed Jan 12 11:38:31 1994 (serrano)                */
;*                                                                     */
;*    Les fonctions utilisees par `Rgc'                                */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __rgc
   (foreign (define obj c-input-port-ajust-cursor      (obj)
	       "INPUT_PORT_AJUST_CURSOR")
	    (obj c-input-port-get-string               (obj)
	       "input_port_get_string")
	    (obj c-input-port-get-small-string         (obj)
	       "input_port_get_small_string")
	    (obj c-input-port-get-symbol               (obj)
	       "input_port_get_symbol")
	    (define obj c-input-port-get-length        (obj)
	       "INPUT_PORT_GET_LENGTH")
	    (define obj c-input-port-stole-char        (obj)
	       "INPUT_PORT_STOLE_CHAR")
	    (define bool c-input-port-fill-buffer      (obj)
	       "input_port_fill_buffer")
	    (define obj c-input-port-throw-char        (obj bint)
	       "INPUT_PORT_THROW_CHAR")
	    (define int c-input-port-read-char         (obj)
	       "INPUT_PORT_READ_CHAR")
	    (define obj c-input-port-remember-back-ref (obj)
	       "INPUT_PORT_REMEMBER_BACK_REF")
	    (define obj c-input-port-remember-ref      (obj)
	       "INPUT_PORT_REMEMBER_REF") 
	    (define obj c-input-port-eof?              (obj) 
	       "INPUT_PORT_EOFP")
	    (define obj c-input-port-eol?              (obj)
	       "INPUT_PORT_EOLP")
	    (define obj c-input-port-bol?              (obj)
	       "INPUT_PORT_BOLP")
	    (obj c-input-port-display-error            (obj boutput-port)
	       "input_port_display_error")
	    (obj c-input-port-read-string              (obj bint)
	       "intput_port_read_string")
	    (define bool input-port-token-too-large?   (obj)
	       "INPUT_PORT_TOKEN_TOO_LARGEP")
	    (obj c-input-port-debug (obj obj) "input_port_debug")
	    (define bool c-rgc-=?  (int int) "EQ_I")
	    (define bool c-rgc-<?  (int int) "LT_I")
	    (define bool c-rgc-<=? (int int) "LE_I")
	    (define bool c-rgc->?  (int int) "GT_I")
	    (define bool c-rgc->=? (int int) "GE_I"))
   (export  (inline input-port-ajust-cursor      port)
	    (inline input-port-get-string        port)
	    (inline input-port-get-small-string  port)
	    (inline input-port-get-symbol        port)
	    (inline input-port-get-length        port)
	    (inline input-port-stole-char        port)
	    (inline input-port-fill-buffer       port)
	    (inline input-port-throw-char        port number)
	    (inline input-port-read-char         port)
	    (inline input-port-remember-ref      port)
	    (inline input-port-remember-back-ref port)
	    (inline input-port-eof?              port)
	    (inline input-port-eol?              port)
	    (inline input-port-bol?              port)
	    (inline input-port-display-error     port port)
	    (inline rgc-=?                       a b)
	    (inline rgc-<?                       a b)
	    (inline rgc-<=?                      a b)
	    (inline rgc->?                       a b)
	    (inline rgc->=?                      a b)))

;*---------------------------------------------------------------------*/
;*    input-port-ajust-cursor ...                                      */
;*    -------------------------------------------------------------    */
;*    Cette fonction trippote tous les curseurs (`forward', `backward' */
;*    et `remember').                                                  */
;*---------------------------------------------------------------------*/
(define-inline (input-port-ajust-cursor input-port)
   (c-input-port-ajust-cursor input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-string ...                                        */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne une string `bigloo' qui est extraite     */
;*    du buffer du lecteur entre les curseurs `mark' et `backward'     */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-string input-port)
   (c-input-port-get-string input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-small-string ...                                  */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne une string `bigloo' qui est extraite     */
;*    du buffer du lecteur entre les curseurs `mark' + 1 et            */
;*    `backward' - 1. Le decalage est la pour supprimer les '"' tapes  */
;*    par l'utilisateur lors d'une lecture.                            */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-small-string input-port)
   (c-input-port-get-small-string input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-symbol ...                                        */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne une symbol `bigloo' qui est extraite     */
;*    du buffer du lecteur entre les curseurs `backward' et            */
;*    `remember'                                                       */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-symbol input-port)
   (c-input-port-get-symbol input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-length ...                                        */
;*    -------------------------------------------------------------    */
;*    Quasiment idem a ci-dessus mais on retourne un int qui est la    */
;*    difference entre les curseurs                                    */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-length input-port)
   (c-input-port-get-length input-port))

;*---------------------------------------------------------------------*/
;*    input-port-stole-char ...                                        */
;*    -------------------------------------------------------------    */
;*    Cette fonction permet de supprimer le char du buffer qui est     */
;*    pointe par `backward'                                            */
;*---------------------------------------------------------------------*/
(define-inline (input-port-stole-char input-port)
   (c-input-port-stole-char input-port))

;*---------------------------------------------------------------------*/
;*    input-port-remember-ref ...                                      */
;*---------------------------------------------------------------------*/
(define-inline (input-port-remember-ref input-port)
   (c-input-port-remember-ref input-port))

;*---------------------------------------------------------------------*/
;*    input-port-remember-back-ref ...                                 */
;*---------------------------------------------------------------------*/
(define-inline (input-port-remember-back-ref input-port)
   (c-input-port-remember-back-ref input-port))

;*---------------------------------------------------------------------*/
;*    input-port-fill-buffer ...                                       */
;*---------------------------------------------------------------------*/
(define-inline (input-port-fill-buffer input-port)
   (c-input-port-fill-buffer input-port))

;*---------------------------------------------------------------------*/
;*    input-port-throw-char ...                                        */
;*---------------------------------------------------------------------*/
(define-inline (input-port-throw-char input-port n)
   (c-input-port-throw-char input-port n))

;*---------------------------------------------------------------------*/
;*    input-port-read-char ...                                         */
;*    input-port --> int                                               */
;*---------------------------------------------------------------------*/
(define-inline (input-port-read-char input-port)
   (c-input-port-read-char input-port))

;*---------------------------------------------------------------------*/
;*    input-port-eof? ...                                              */
;*    input-port --> { t, f }                                          */
;*---------------------------------------------------------------------*/
(define-inline (input-port-eof? input-port)
   (c-input-port-eof? input-port))

;*---------------------------------------------------------------------*/
;*    input-port-eol? ...                                              */
;*    input-port --> { t, f }                                          */
;*---------------------------------------------------------------------*/
(define-inline (input-port-eol? input-port)
   (c-input-port-eol? input-port))
 
;*---------------------------------------------------------------------*/
;*    input-port-bol? ...                                              */
;*    input-port --> { t, f }                                          */
;*---------------------------------------------------------------------*/
(define-inline (input-port-bol? input-port)
   (c-input-port-bol? input-port))

;*---------------------------------------------------------------------*/
;*    input-port-debug ...                                             */
;*---------------------------------------------------------------------*/
(define (input-port-debug input-port . file)
   (if (null? file)
       (c-input-port-debug input-port (current-output-port))
       (c-input-port-debug input-port (car file))))

;*---------------------------------------------------------------------*/
;*    input-port-display-error ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (input-port-display-error ip op)
   (c-input-port-display-error ip op))
    
;*---------------------------------------------------------------------*/
;*    rgc-=? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (rgc-=? a b)
   (c-rgc-=? a b))
   
;*---------------------------------------------------------------------*/
;*    rgc-<? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (rgc-<? a b)
   (c-rgc-<? a b))
   
;*---------------------------------------------------------------------*/
;*    rgc-<=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (rgc-<=? a b)
   (c-rgc-<=? a b))
   
;*---------------------------------------------------------------------*/
;*    rgc->? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (rgc->? a b)
   (c-rgc->? a b))
   
;*---------------------------------------------------------------------*/
;*    rgc->=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (rgc->=? a b)
   (c-rgc->=? a b))
   
