;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Llib/system.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jan 20 08:47:31 1993                          */
;*    Last change :  Mon Jan 17 10:14:09 1994 (serrano)                */
;*                                                                     */
;*    Le fichier ou sont rangees les fonctions systemes                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __system
   (foreign (obj    c-signal  (int bprocedure)    "c_signal")
	    (define bool c-getenv? (string)       "getenv")
	    (string c-getenv  (string)            "getenv")
	    (int    c-system  (string)            "system")
	    (string c-date    ()                  "c_date")
	    (int    c-chdir   (string)            "chdir")
	    (define obj location        (obj)     "LOCATION")
	    (define obj c-location-ref  (obj)     "LOCATION_REF")
	    (define obj c-location-set! (obj obj) "LOCATION_SET")
	    (obj    *the-command-line*  "command_line"))
   (export  (signal num thunk)
	    (inline getenv string)
	    (inline system string)
	    (inline date)
	    (inline chdir string)
	    (inline location-ref  variable)
	    (inline location-set! variable value)
	    (command-line))
   (pragma  (location _no_side_effect_ _no_mutation_ _imbricable_)))

;*---------------------------------------------------------------------*/
;*    command-line ...                                                 */
;*---------------------------------------------------------------------*/
(define (command-line)
   *the-command-line*)

;*---------------------------------------------------------------------*/
;*    signal ...                                                       */
;*---------------------------------------------------------------------*/
(define (signal num proc)
   (cond
      ((not (=fx (procedure-arity proc) 1))
       (error "signal" "Wrong number of arguments" proc))
      ((or (<fx num 0) (>fx num 31))
       (error "signal" "Illegal signal" num))
      (else
       (c-signal num proc))))

;*---------------------------------------------------------------------*/
;*    getenv ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (getenv string)
   (if (c-getenv? string)
       (c-getenv string)
       #f))

;*---------------------------------------------------------------------*/
;*    system ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (system string)
   (c-system string))
   
;*---------------------------------------------------------------------*/
;*    date ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (date)
   (c-date))

;*---------------------------------------------------------------------*/
;*    chdir ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (chdir dirname)
   (c-chdir dirname))

;*---------------------------------------------------------------------*/
;*    location-ref ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (location-ref obj)
   (c-location-ref obj))

;*---------------------------------------------------------------------*/
;*    location-set! ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (location-set! obj val)
   (c-location-set! obj val))

