;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/work/Pp/Pp/make-rep.scm ...          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 27 10:45:32 1993                          */
;*    Last change :  Mon Dec  6 09:05:03 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Un essai de `printer-passing-style'                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __pp-make-rep
   (import (*pp-case*     __pp "Pp/pp.scm")
	   (*pp-optimize* __pp "Pp/pp.scm"))
   (export (make-rep exp)))

;*---------------------------------------------------------------------*/
;*    make-rep ...                                                     */
;*---------------------------------------------------------------------*/
(define (make-rep exp)
   (list (initial-printer exp initial-printer)
	 '((tab 0))))

;*---------------------------------------------------------------------*/
;*    initial-printer ...                                              */
;*    exp x column x printer --> rep                                   */
;*---------------------------------------------------------------------*/
(define (initial-printer x p)
   (let ((p1 (cond
		((not (pair? x))
		 (atom-printer x))
		((symbol? (car x))
		 (let ((printer (getprop (if (eq? *pp-case* 'respect)
					     (string->symbol
					      (string-upcase
					       (symbol->string (car x))))
					     (car x))
					 'printer)))
		    (if printer
			printer
			*application-printer*)))
		(else
		 *application-printer*))))
      (p1 x p)))

;*---------------------------------------------------------------------*/
;*    atom-printer ...                                                 */
;*---------------------------------------------------------------------*/
(define (atom-printer x)
   (cond
      ((symbol? x)
       *symbol-printer*)
      ((string? x)
       *string-printer*)
      ((number? x)
       *number-printer*)
      ((null? x)
       *null-printer*)
      ((char? x)
       (lambda (x p)
	  `(char ,x)))
      ((boolean? x)
       (lambda (x p)
	  (if x
	      "#t"
	      "#f")))
      ((eof-object? x)
       (lambda (x p)
	  "<eof-object>"))
      ((input-port? x)
       (lambda (x p)
	  "<input-port>"))
      ((output-port? x)
       (lambda (x p)
	  "<output-port>"))
      ((and (vector? x) (eq? (vector-ref x 0) 'comment))
       *comment-printer*)
      (else
       (lambda (x p)
	  "<???>"))))
   
;*---------------------------------------------------------------------*/
;*    *symbol-printer* ...                                             */
;*---------------------------------------------------------------------*/
(define *symbol-printer* (lambda (x p)
			    (let ((string (symbol->string x)))
			       (case *pp-case*
				  ((upper)
				   (string-upcase string))
				  ((lower)
				   (string-downcase string))
				  (else
				   string)))))

;*---------------------------------------------------------------------*/
;*    *string-printer* ...                                             */
;*---------------------------------------------------------------------*/
(define *string-printer*
   (lambda (x p)
      (let* ((len (string-length x))
	     (res (make-string (*fx 3 len)))
	     (w   0)
	     (c?  #f))
	 (define (*string++ char)
	    (string-set! res w char)
	    (set! w (+fx w 1)))
	 (*string++ #\#)
	 (*string++ #\")
	 (let loop ((r  0))
	    (if (=fx r len)
		(begin
		   (*string++ #\")
		   (if c?
		       (substring res 0 w)
		       (substring res 1 w)))
		(let ((current-char (string-ref x r)))
		   (case (char->integer current-char)
		      ((7);; alert
		       (*string++ #\\)
		       (*string++ #\a)
		       (set! c? #t)
		       (loop (+fx r 1)))
		      ((8);; bask space
		       (*string++ #\\)
		       (*string++ #\b)
		       (set! c? #t)
		       (loop (+fx r 1)))
		      ((9);; horizontal tabulation
		       (*string++ #\\)
		       (*string++ #\t)
		       (set! c? #t)
		       (loop (+fx r 1)))
		      ((10);; new line
		       (*string++ #\\)
		       (*string++ #\n)
		       (set! c? #t)
		       (loop (+fx r 1)))
		      ((11);; vertical tabulation
		       (*string++ #\\)
		       (*string++ #\v)
		       (set! c? #t)
		       (loop (+fx r 1)))
		      ((12);; form feed
		       (*string++ #\\)
		       (*string++ #\f)
		       (set! c? #t)
		       (loop (+fx r 1)))
		      ((13);; carriage return
		       (*string++ #\\)
		       (*string++ #\r)
		       (set! c? #t)
		       (loop (+fx r 1)))
		      ((34);; double-guillemet
		       (*string++ #\\)
		       (*string++ #\")
		       (loop (+fx r 1)))
		      ((92);; slash
		       (*string++ #\\)
		       (*string++ #\\)
		       (set! c? #t)
		       (loop (+fx r 1)))
		      (else
		       (*string++ current-char)
		       (loop (+fx r 1))))))))))

;*---------------------------------------------------------------------*/
;*    *number-printer* ...                                             */
;*---------------------------------------------------------------------*/
(define *number-printer* (lambda (x p)
			    (cond
			       ((integer? x)
				(integer->string x))
			       ((real? x)
				(real->string x)))))

;*---------------------------------------------------------------------*/
;*    *null-printer* ...                                               */
;*---------------------------------------------------------------------*/
(define *null-printer*   (lambda (x p)
			    "()"))

;*---------------------------------------------------------------------*/
;*    *application-printer* ...                                        */
;*---------------------------------------------------------------------*/
(define (*application-printer* x p)
   (let ((fun  (p (car x) p)))
      (if (null? (cdr x))
	  `(#\( ,fun #\))
	  (let ((args (*args-printer* (cdr x) p)))
	     `(#\( ,fun ,args #\))))))

;*---------------------------------------------------------------------*/
;*    args-printer/tab ...                                             */
;*---------------------------------------------------------------------*/
(define (args-printer/tab args p)
   (let ((args-tab     (args-printer-sep args p '(tab 3)))
	 (args-newline `(#\space (mark-tab)
				 ,(p (car args) p)
				 ,@(args-printer-sep (cdr args) p '(tab 0))))
	 (args-space (begin
			(set! *args-printer* args-printer-sans-tab)
			(let ((r (args-printer-sep args p #\space)))
			   (set! *args-printer* args-printer/tab)
			   r))))
      (if (=fx *pp-optimize* 0)
	  args-space
	  `(or ,args-space ,args-newline ,args-tab))))

;*---------------------------------------------------------------------*/
;*    args-printer-sans-tab ...                                        */
;*---------------------------------------------------------------------*/
(define (args-printer-sans-tab args p)
   (args-printer-sep args p #\space))

;*---------------------------------------------------------------------*/
;*    args-printer-sep ...                                             */
;*---------------------------------------------------------------------*/
(define (args-printer-sep args p sep)
   (let loop ((args (mappair (lambda (a) (p a p)) args))
	      (res  '()))     
      (if (null? args)
	  (reverse! res)
	  (loop (cdr args)
		(cons (car args) (cons sep res))))))

;*---------------------------------------------------------------------*/
;*    *args-printer* ...                                               */
;*---------------------------------------------------------------------*/
(define *args-printer* args-printer/tab)

;*---------------------------------------------------------------------*/
;*    install-printer ...                                              */
;*---------------------------------------------------------------------*/
(define (install-printer keyword printer)
   (putprop! keyword 'printer printer))

;*---------------------------------------------------------------------*/
;*    printer-list ...                                                 */
;*---------------------------------------------------------------------*/
(define (printer-list list p)
   (cond
      ((not (pair? list))
       (p list p))
      (else
       `(#\( ,(printer-list (car list) p)
	     ,@(let loop ((list (cdr list))
			  (res  '()))
		  (cond
		     ((null? list)
		      (reverse! (cons #\) res)))
		     ((not (pair? list))
		      (reverse! `(#\) ,(p list p) " . " ,@res)))
		     (else
		      (loop (cdr list)
			    (cons (printer-list (car list) p)
				  (cons '(space-cut) res))))))))))
	      
;*---------------------------------------------------------------------*/
;*    printer* ...                                                     */
;*---------------------------------------------------------------------*/
(define (printer* p exps sep start end)
   (let loop ((exps exps)
	      (res  '()))
      (if (null? exps)
	  (append start (reverse! (if (pair? end)
				      (append end res)
				      (cons end res))))
	  (loop (cdr exps)
		(cons `(,sep ,(p (car exps) p))
		      res)))))

;*---------------------------------------------------------------------*/
;*    lambda-printer ...                                               */
;*---------------------------------------------------------------------*/
(define (lambda-printer x p)
   (printer* p
	     (cddr x)
	     '(tab 3)
	     `(#\( ,(p (car x) p) #\space
		   ,(printer-list (cadr x) p))
	     #\)))

;*---------------------------------------------------------------------*/
;*    define-printer ...                                               */
;*---------------------------------------------------------------------*/
(install-printer 'define
		 (lambda (x p)
		    (match-case x
		       ((define (atom ?-) (atom ?-))
			`(,(printer-list x p) (tab 0)))
		       (else
			`(,(lambda-printer x p) (tab 0))))))

;*---------------------------------------------------------------------*/
;*    lambda & defun                                                   */
;*---------------------------------------------------------------------*/
(install-printer 'lambda lambda-printer)
(install-printer 'defun  (lambda (x p)
			    `(,(lambda-printer x p) (tab 0))))
(install-printer 'set! (lambda (x p)
			  `(or (#\( ,(p (car x) p) #\space ,(p (cadr x) p)
				    #\space ,(p (caddr x) p) #\))
			       (#\( ,(p (car x) p) #\space ,(p (cadr x) p)
				    (tab 3) ,(p (caddr x) p) #\)))))

;*---------------------------------------------------------------------*/
;*    if-printer ...                                                   */
;*---------------------------------------------------------------------*/
(install-printer 'if
		 (lambda (x p)
		    (printer* p
			      (cddr x)
			      '(tab 4)
			      `(#\( ,(p (car x) p) #\space ,(p (cadr x) p))
			      #\))))

;*---------------------------------------------------------------------*/
;*    begin-printer ...                                                */
;*---------------------------------------------------------------------*/
(install-printer 'begin
		 (lambda (x p)
		    (printer* p
			      (cdr x)
			      '(tab 3)
			      `(#\( ,(p (car x) p))
			      #\))))

;*---------------------------------------------------------------------*/
;*    let-printer ...                                                  */
;*---------------------------------------------------------------------*/
(define (let-printer x p)
   (define (printer-binding b p)
      (if (not (pair? b))
	  (p b p)
	  `(#\( ,(p (car b) p) (space-cut) ,@(map (lambda (x)
						     (p x p))
						  (cdr b))
		#\))))
   (match-case x
      ((?- () . ?body)
       (printer* p
		 body
		 '(tab 3)
		 `(#\( ,(p (car x) p) #\space ,(p (cadr x) p))
		 #\)))
      ((?- (atom ?-) () . ?body)
       (printer* p
		 body
		 '(tab 3)
		 `(#\( ,(p (car x) p) #\space ,(p (cadr x) p) #\space
		       ,(p (caddr x) p))
		 #\)))
      ((?- (atom ?-) ?bindings . ?body)
       (printer* p
		 body
		 '(tab 3)
		 `(#\( ,(p (car x) p) #\space ,(p (cadr x) p) #\space
		       ,(printer* (lambda (x new-p)
				     (printer-binding x p))
				  (cdr bindings)
				  '(tab 1)
				  `(#\( ,(printer-binding (car bindings) p))
				  #\)))
		 #\)))
      ((?- ?bindings . ?body)
       (printer* p
		 body
		 '(tab 3)
		 `(#\( ,(p (car x) p) #\space
		       ,(printer* (lambda (x new-p)
				     (printer-binding x p))
				  (cdr bindings)
				  '(tab 1)
				  `(#\( ,(printer-binding (car bindings) p))
				  #\)))
		 #\)))))
		   
;*---------------------------------------------------------------------*/
;*    printer-let ...                                                  */
;*---------------------------------------------------------------------*/
(install-printer 'let let-printer)
(install-printer 'let* let-printer)
(install-printer 'letrec let-printer)

;*---------------------------------------------------------------------*/
;*    cond-printer ...                                                 */
;*---------------------------------------------------------------------*/
(define (cond-printer x p)
   (printer* (lambda (x new-p)
		(if (not (pair? x))
		    (p x p)
		    (printer* p
			      (cdr x)
			      '(tab 1)
			      `(#\( ,(p (car x) p))
			      #\))))
	     (cdr x)
	     '(tab 3)
	     `(#\( ,(p (car x) p))
	     #\)))

;*---------------------------------------------------------------------*/
;*    case-printer ...                                                 */
;*---------------------------------------------------------------------*/
(define (case-printer x p)
   (printer* (lambda (x new-p)
		(if (not (pair? x))
		    (p x p)
		    (printer* p
			      (cdr x)
			      '(tab 1)
			      `(#\( ,(printer-list (car x) p))
			      #\))))
	     (cddr x)
	     '(tab 3)
	     `(#\( ,(p (car x) p) #\space ,(p (cadr x) p))
	     #\)))

;*---------------------------------------------------------------------*/
;*    cond & case                                                      */
;*---------------------------------------------------------------------*/
(install-printer 'cond cond-printer)
(install-printer 'case case-printer)
(install-printer 'match-case case-printer)
		   
;*---------------------------------------------------------------------*/
;*    quote-printer ...                                                */
;*---------------------------------------------------------------------*/
(define (quote-printer x p)
   (let ((pr (case (car x)
		((quote)
		 #\')
		((unquote)
		 #\,)
		((quasiquote)
		 #\`)
		((unquote-splicing)
		 ",@"))))
      `(,pr ,(p-cnst (cadr x) p))))

;*---------------------------------------------------------------------*/
;*    p-cnst ...                                                       */
;*---------------------------------------------------------------------*/
(define (p-cnst x p)
   (cond
      ((pair? x)
       (printer-list x p))
      ((vector? x)
       `(,#\# ,(printer-list (vector->list x) p)))
      (else
       (p x p))))
   
;*---------------------------------------------------------------------*/
;*    quote                                                            */
;*---------------------------------------------------------------------*/
(install-printer 'quote quote-printer)
(install-printer 'unquote quote-printer)
(install-printer 'quasiquote quote-printer)
(install-printer 'unquote-splicing quote-printer)
			   
;*---------------------------------------------------------------------*/
;*    module-printer ...                                               */
;*---------------------------------------------------------------------*/
(define (module-printer x p)
   (printer* (lambda (x new-p)
		(printer-list x p))
	     (cddr x)
	     '(tab 3)
	     `(#\( ,(p (car x) p) #\space ,(p (cadr x) p))
	     '((tab 0) #\))))

;*---------------------------------------------------------------------*/
;*    module & directives                                              */
;*---------------------------------------------------------------------*/
(install-printer 'module module-printer)
(install-printer 'directives module-printer)

;*---------------------------------------------------------------------*/
;*    labels-printer                                                   */
;*---------------------------------------------------------------------*/
(define (labels-printer x p)
   (match-case x
      ((?- () . ?body)
       (printer* p
		 body
		 '(tab 3)
		 `(#\( ,(p (car x) p) #\space ,(p (cadr x) p))
		 #\)))
      ((?- ?bindings . ?body)
       (let ((binding-printer (lambda (x new-p)
				 (printer* p
					   (cddr x)
					   '(tab 3)
					   `(#\(
					     ,(p (car x) p)
					     #\space
					     ,(printer-list (cadr x) p))
					   #\)))))
	  (printer* p
		    body
		    '(tab 3)
		    `(#\( ,(p (car x) p) #\space
			  ,(printer* binding-printer
				     (cdr bindings)
				     '(tab 1)
				     `(#\( ,(binding-printer (car bindings) p))
				     #\)))
		    #\))))))

;*---------------------------------------------------------------------*/
;*    labels                                                           */
;*---------------------------------------------------------------------*/
(install-printer 'labels labels-printer)
   
;*---------------------------------------------------------------------*/
;*    *comment-printer* ...                                            */
;*---------------------------------------------------------------------*/
(define (*comment-printer* x p)
   (match-case x
      (#(comment full-line ?str)
       `(comment ,str))
      (#(comment after ?str)
       `(comment ,str))))

;*---------------------------------------------------------------------*/
;*    mappair ...                                                      */
;*---------------------------------------------------------------------*/
(define (mappair f l)
   (let loop ((l   l))
      (cond
	 ((null? l)
	  '())
	 ((not (pair? l))
	  (f l))
	 (else
	  (cons (f (car l)) (loop (cdr l)))))))
