;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Rgc/grammar.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  3 15:50:20 1992                          */
;*    Last change :  Wed Jan 12 11:37:49 1994 (serrano)                */
;*                                                                     */
;*    La compilation des automates                                     */
;*---------------------------------------------------------------------*/
  
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __rgc_grammar
   (import  (__rgc_trap     "Rgc/trap.scm")
	    (__rgc_automata "Rgc/automata.scm"))
   (export  (build-regular-grammar ns ua tt)))

;*---------------------------------------------------------------------*/
;*    build-regular-grammar ...                                        */
;*    (int x states) x sexp x vector --> lambda                        */
;*---------------------------------------------------------------------*/
(define (build-regular-grammar nb-states.states usr-action* t-trap)
   (let ((nb-states  (car nb-states.states))
	 (states     (cdr nb-states.states))
	 (nb-actions (length usr-action*)))
      (pre-trap t-trap)
      `(lambda (input-port)
	  (let ((current-context 0))
	     (labels ((context new-context
			       (set! current-context
				     (if (null? new-context)
					 '()
					 (car new-context))))
		      (the-length () (input-port-get-length input-port))
		      (the-string () (input-port-get-string input-port))
		      (the-small-string () (input-port-get-small-string
					    input-port))
		      (the-symbol () (input-port-get-symbol input-port))
		      (the-failing-char ()
					(input-port-stole-char input-port))
		      (automata (rule)
				,(build-automata nb-states states t-trap))
		      (ignore ()
			      (let ((rule (automata 0)))
				 (input-port-ajust-cursor input-port)
				 (case rule
				    ,@(let loop ((indice  (-fx nb-actions 1))
						 (action* (cdr usr-action*)))
					 (if (null? action*)
					     '()
					     (cons
					      `((,indice)
						,(car action*))
					      (loop (-fx indice 1)
						    (cdr action*)))))
				    (else
				     (if (input-port-token-too-large?
					  input-port)
					 (error "regular-grammar"
						"token too large"
						(unspecified)))
				     ,(car usr-action*))))))
		(ignore))))))
	      


