/*
 * Primitive.h -- Declarations for Scheme Primitives
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) Primitive.h (C) M.Blume, Princeton University, 2.4"
 */

# ifndef PRIMITIVE_H_
# define PRIMITIVE_H_

# include "storage.h"

typedef
struct ScmPrimitive {
  MEM_descriptor _;
  unsigned (* const code) (unsigned argcnt);
  unsigned (* const cont) (void);
  unsigned seq_num;
  const char * const name;
  int expected_argcnt;		/* -1 to avoid automatic checking */
} ScmPrimitive;

DCL_MEM_TYPE (Primitive);

extern const unsigned ScmPrimitive_num;
extern ScmPrimitive ScmPrimitive_array[];
# define GetScmPrimitive(p) (&ScmPrimitive_array [p])

# endif
