/*
 * vect-prim.c -- Implementation of Scheme's primitive vector procedures
 *
 * (C) m.b (Matthias Blume); Jun 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * ident "@(#) vect-prim.c (C) M.Blume, Princeton University, 2.4"
 */

# ident "@(#)vect-prim.c	(C) M.Blume, Princeton University, 2.4"

# include "Code.h"
# include "Cont.h"
# include "Vector.h"
# include "Boolean.h"
# include "Numeric.h"
# include "Cons.h"
# include "type.h"
# include "except.h"

# include "builtins.tab"

/*ARGSUSED*/
unsigned ScmPrimitiveListToVector (unsigned argcnt)
{
  ScmListToVector ();
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveVectorP (unsigned argcnt)
{
  void *tmp = PEEK ();

  SET_TOP (ScmTypeOf (tmp) == ScmType (Vector) ? &ScmTrue : &ScmFalse);
  return 0;
}

unsigned ScmPrimitiveMakeVector (unsigned argcnt)
{
  void *fill;
  unsigned long len, i;
  ScmVector *vect;

  if (argcnt < 1 || argcnt > 2)
    error ("wrong arg cnt (%u) to primitive procedure make-vector",
	   (unsigned) argcnt);
  len = ScmNumberToULong (PEEK (), "make-vector");
  SCM_NEW_VECTOR (vect, len);
  if (argcnt == 2) {
    (void) POP ();
    fill = PEEK ();
  } else
    fill = &ScmFalse;
  for (i = 0; i < len; i++)
    vect->array [i] = fill;
  SET_TOP (vect);
  return 0;
}

unsigned ScmPrimitiveVector (unsigned argcnt)
{
  ScmVector *vect;
  unsigned i;

  SCM_NEW_VECTOR (vect, argcnt);
  for (i = 0; i < argcnt; i++)
    vect->array [i] = POP ();
  Push (vect);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveVectorLength (unsigned argcnt)
{
  ScmVector *vect = PEEK ();
  void *tmp;
  unsigned long len;

  if (ScmTypeOf (vect) != ScmType (Vector))
    error ("bad arg to vector-length: %w", vect);
  len = vect->length;
  tmp = ScmLongToNumber (len);
  SET_TOP (tmp);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveVectorRef (unsigned argcnt)
{
  ScmVector *vect;
  unsigned long k;

  vect = POP ();
  if (ScmTypeOf (vect) != ScmType (Vector))
    error ("bad arg to vector-ref: %w", vect);
  k = ScmNumberToULong (PEEK (), "vector-ref");
  if (k >= vect->length)
    error ("vector-ref: %w [%w] (index out of bounds)", vect, PEEK ());
  SET_TOP (vect->array [k]);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveVectorSet (unsigned argcnt)
{
  ScmVector *vect;
  unsigned long k;
  void *vk;

  vect = POP ();
  if (ScmTypeOf (vect) != ScmType (Vector))
    error ("bad arg to vector-set!: %w", vect);
  vk = POP ();
  k = ScmNumberToULong (vk, "vector-set!");
  if (k >= vect->length)
    error ("vector-set!: %w [%w] (index out of bounds)", vect, vk);
  vect->array [k] = PEEK ();
  SET_TOP (vect);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveVectorToList (unsigned argcnt)
{
  ScmVector *vect = PEEK ();
  unsigned long len;
  ScmCons *cons;
  void *nxt;

  if (ScmTypeOf (vect) != ScmType (Vector))
    error ("bad arg to primitive procedure vector->list: %w", vect);
  len = vect->length;
  if (len == 0) {
    SET_TOP (&ScmNil);
    return 0;
  }
  SCM_ALLOC (cons, len * sizeof (ScmCons));
  vect = PEEK ();
  nxt = &ScmNil;
  while (len-- > 0) {
    cons [len]._ = ScmType (Cons);
    cons [len].cdr = nxt;
    cons [len].car = vect->array [len];
    nxt = cons + len;
  }
  SET_TOP (cons);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveVectorFill (unsigned argcnt)
{
  ScmVector *vect;
  void *fill;
  unsigned long i;

  vect = POP ();
  fill = PEEK ();
  if (ScmTypeOf (vect) != ScmType (Vector))
    error ("bad arg to primitive procedure vector->fill!: %w", vect);
  i = vect->length;
  while (i--)
    vect->array [i] = fill;
  SET_TOP (vect);
  return 0;
}
