%{
/* schemeTeX -- Scheme to TeX.  John D. Ramsdell.
 * Simple support for literate programming in Scheme.
 * Usage:   schemeTeX < {Scheme TeX file} > {TeX file}
 */

#if !defined lint
static char ID[] = "@(#)schemeTeX.l	1.3	88/06/30";
static char copyright[] = "Copyright 1988 by The MITRE Corporation."; 
/* Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies.  The
MITRE Corporation makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty. 

Modified by Pertti Kellom\"aki to support GNU Texinfo

*/
#endif

/* SchemeTeX defines a new source file format in which source lines
are divided into text and code.  Lines of code start with a line
beginning with '(', and continue until the line that contains the
matching ')'.  The text lines remain, and they are treated as
comments.  If the first character of a text line is ';', it is
stripped from the output.  This is provided for those who want to use
an unmodified version of their Scheme system's LOAD.  When producing a
document, both the text lines and the code lines are copied into the
document source file, but the code lines are surrounded by a pair of
formatting commands, as is comments beginning with ';' within code
lines.  SchemeTeX is currently set up for use with LaTeX.

If you want to produce texinfo, use flag -texinfo
Use -strip if you want to remove all comments in a Scheme TeX
file.
*/

#define FALSE 0
#define TRUE 1

#define LATEX_BEGIN_COMMENT	"\\notastyped{"
#define LATEX_BEGIN_CODE	"\\begin{astyped}"
#define LATEX_END_CODE	"\\end{astyped}"
#define LATEX_ECHO	latex_verbatim_echo(yytext, stdout)
#define INFO_BEGIN_COMMENT	"{"
#define INFO_BEGIN_CODE	"@example"
#define INFO_END_CODE	"@end example"
#define INFO_ECHO	info_verbatim_echo(yytext, stdout)

#define LATEX 0
#define TEXINFO 1
 
/* Lex is used for identifying code in an Scheme TeX file. */
int parens;			/* Used to balance parenthesis. */
char *begin_code;               /* The actual strings to output */
char *end_code;
char *begin_comment;
int format;                     /* Which format to output */
int strip;
int inside_block_comment;       /* Flag for detecting block comments */
                                /* within code (formatted with TeX)  */

/* All input occurs in the following routines so that TAB characters
can be expanded. TeX treats TAB characters as a space--not what is
wanted. */
#undef getc()
#define getc(STREAM) expanding_getc(STREAM)
int spaces = 0;			/* Spaces left to print a TAB. */
int column = 0;			/* Current input column. */
int expanding_getc(stream)
  FILE *stream;
{
  int c;
  if (spaces > 0) {
    spaces--;
    return ' ';
  }
  switch (c = fgetc(stream)) {
  case '\t':
    spaces = 8 - (7&column);
    column += spaces;
    return expanding_getc(stream);
  case '\n':
    column = 0;
    return c;
  default:
    column++;
    return c;
  }
}
%}
%%
^[^;]           {
                  if (inside_block_comment) {
                    fputs(begin_code, stdout);
		    inside_block_comment = FALSE;
		  }
                  REJECT;
                }
^;[^\n]*$	{
                  /* If a comment line starts in the first column, turn off */
		  /* code section until a line that does not start with a   */
		  /* semicolon is found.                                    */
                  if (!strip) {
                    if (!inside_block_comment) {
                      fputs(end_code, stdout);
		      printf("\n");
		    }
		    printf("%s", &yytext[1]);
                    inside_block_comment = TRUE;
		  }
		}
#\\\(		{
                  if (strip)		   
                     ECHO;
		  else
                     switch (format) {
		     case LATEX:
		       LATEX_ECHO;
		       break;
		     case TEXINFO:
		       INFO_ECHO;
		     };
		}
#\\\)		{
                  if (strip)		   
                     ECHO;
		  else
                     switch (format) {
		     case LATEX:
		       LATEX_ECHO;
		       break;
		     case TEXINFO:
		       INFO_ECHO;
		     };
		}
\(		{ ECHO; parens++; }
\)		{ ECHO; parens--;
		  if (parens == 0) { /* End of code. */
		    char c;	/* Check that nothing follows. */
		    while ((c = input()) == ' ') output(c);
		    if (c == '\000') return 0; /* EOF */
		    if (c != '\n' && c != ';') return -1;
		    unput(c);
		  }
		}
\"[^"]*\"	{
                  if ((yyleng > 1) && (yytext[yyleng-2] == '\\'))
		    yymore();
		  else if (strip)		   
                     ECHO;
		  else {
		    switch (format) {
		    case LATEX:
		      LATEX_ECHO;
		      break;
		    case TEXINFO:
		      INFO_ECHO;
		    }
		  }
		}
;[^\n]*$	{
                  if (!strip) {
		    fputs(begin_comment, stdout);
		    ECHO;
		    fputs("}", stdout);
		  }
		}
\n		{ ECHO; if (parens <= 0) return 0; }
.		{
                  if (strip)		   
                     ECHO;
		  else
                     switch (format) {
		     case LATEX:
		       LATEX_ECHO;
		       break;
		     case TEXINFO:
		       INFO_ECHO;
		     };
		}
%%

fatal (s)
      char *s;
{
  fprintf(stderr, "On line %d, %s\n", yylineno, s);
  exit(1);
}

latex_verbatim_echo (s, f)
      char *s; FILE *f;
{
  for (; *s != '\000'; s++) 
    switch (*s) {
    case '\\': 
    case  '{': 
    case  '}': 
    case  '$': 
    case  '&': 
    case  '#': 
    case  '^': 
    case  '_': 
    case  '%': 
    case  '~': 
      fputs("\\verb-", f);
      putc(*s, f);
      putc('-', f);
      break;
    default: putc(*s, f);
    }
}

info_verbatim_echo (s, f)
      char *s; FILE *f;
{
  for (; *s != '\000'; s++) 
    switch (*s) {
    case '@': 
    case  '{': 
    case  '}': 
      fputs("@", f);
      putc(*s, f);
      break;
    default: putc(*s, f);
    }
}

int option(opt, argc, argv)
     char *opt;
     int argc;
     char *argv[];
{
  int i;
  
  for(i = 0; i < argc; i++)
    if (strcmp(argv[i], opt) == 0)
      return TRUE;
  return FALSE;
}

main(argc, argv)
     int argc;
     char *argv[];
{
  char c;

  /* check for options, default is LaTeX format and no strip */
  format = LATEX;
  begin_code = LATEX_BEGIN_CODE;
  end_code = LATEX_END_CODE;
  begin_comment = LATEX_BEGIN_COMMENT;
  if (option("-texinfo", argc, argv)) {
      begin_code = INFO_BEGIN_CODE;
      end_code = INFO_END_CODE;
      begin_comment = INFO_BEGIN_COMMENT;
      format = TEXINFO;
    }
  if (option("-strip", argc, argv))
    strip = TRUE;
  else
    strip = FALSE;

  inside_block_comment = FALSE;
  
  do {				/* TeX mode and saw newline */
    c = input();
    if (c == '(') {		/* TeX mode changed to code mode. */
      unput(c);
      if (!strip)
	fputs(begin_code,stdout); putc('\n', stdout);
      do {			/* Copy out code using yylex. */
	parens = 0;
	if (0 != yylex()) fatal("Bad code section.");
	if (parens != 0) fatal("Premature EOF.");
	c = input();
	unput(c);		/* Repeat when there is code */
      } while (c == '(');	/* immediately after copied code. */
      if (!strip)
	fputs(end_code, stdout); putc('\n', stdout);
    }
    else {			/* Found a text line. */
      if (c == ';') c = input(); /* For those who want to use bare load. */
      while (c != '\n') {
	if (c == '\000') exit(0);	/* EOF. */
	if (!strip)
	  output(c);
	c = input();
      }
      if (!strip)
	output(c);
    }
  } while (1);
}
