;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-browser.cl
;;; Short Desc: A browser to show proof trees
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :pail-lib)




;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================



;;==================================================================


(eval-when (load compile eval)
  (export '( atp-browser)))

(defclass atp-browser (browser)
  ((left-menu :initarg left-menu
	      :initform (make-instance 'menu
			  :items '(("Show clause" atp::show-clause)
				   ("Close" close-atp-browser "Closes the browser display")))
	      :accessor left-menu
	      :type menu)))


(defmethod browser-select-item ((b atp-browser) item mousestate button)
  (let ((ans (accept-items (make-instance 'menu
			    :items  (atp::split-in-lines
				     (atp::clause-to-string-tree  (content item)))))))
    (if ans (apply ans (list item b))))
  (reset-button button))
