;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-dialog.cl
;;; Short Desc: dialog handling for theorem prover
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)



;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================



(defparameter *number-of-demos* 6)
(defparameter *verbose* nil)
(defvar *verbose-disp* nil)
(defvar *original-screen-width*)
(defvar *original-screen-height*)

;;==================================================================
;; THE ATP dialog

(defun start-atp-dialog (&optional (from-button nil))
 
;; ORIGINAL SCREEN DIMENSIONS
;; the higer are these two variables  the smaller
;; is the actual size of windows
 
(setq *original-screen-width* 1300)
(setq *original-screen-height* 950)

(setq *original-default-width* 860)
(setq *default-width* (scalew *original-default-width*))  
  (setq *default-left*  (scalew 288))
  (setq *tool-but-width*  (scalew (/ *original-default-width* 4.05)))
  (setq *tool-win-height* (scaleh 90))
  (setq *tool-but-height*  (scaleh 27))
  (setq *out-win-height* (scaleh 450))
  (setq *msg-win-height* (scaleh 135))
  (setq *tool-but-font* (my-findfont  14))


  ;; BABBEO 
  ;; 
  ;;Restore defaults of GIN source code
  (setq gi::*default-display-border* 2)
  (setf gi::*default-push-button-width* 100)
  (setf gi::*default-push-button-size-p* nil)
  
  (setq *demo-in-execution* nil)
  (if *verbose*
      (progn  (setf *verbose-disp* (make-instance 'scroll-display
				     :title "ATP:Verbose Comments"
				     :width 480
				     :height 150
				     :borders 1
				     :active nil
				     :left (scalew 230)
				     :bottom (scaleh 180)))
	      (activate-display *verbose-disp*)
	      (setf *verbose* *verbose-disp*)
	      (deactivate-display *verbose-disp*))
    (setf *verbose-disp* *verbose*))
  (let* ((disp (make-instance 'display :title "ATP:Main Window"
			      :width (scalew 500)
			      :height (scaleh 240)
			      :borders 1
			      :left (scalew 200)
			      :bottom (scaleh 500)))
	 
	 (menu-button (make-instance 'pop-up-button
			 :font (my-findfont  14)
			 :label "Demos"
			 :width (scalew 100)))
	 (exit-button (make-instance 'push-button 
			:font (my-findfont 14) 
			:label "Exit" :width (scalew 70)))
	 (help-button 
	  (make-instance 'help-button :width (scalew 70) :label "Help" 
			 :subject "Automated Theorem Proving"
			  :font (my-findfont 14)
                         :technical
			 (add-path "atp-desc-tec.asc" (add-subdir *pail-path* "atp"))
			 :general 
			 (add-path "atp-desc-gen.asc" (add-subdir *pail-path* "atp"))))
	 (tool-button (make-instance 'push-button 
			:font (my-findfont 14)
				     :label "Tool" :width (scalew 100)))
	 (menu (make-instance 'menu
		 :items  (let ((mlist nil))
			   (dotimes (i *number-of-demos* (nreverse mlist))
			     (setf mlist 
			       (cons (list (format nil "Demo ~a" (1+ i)) 
					   `(lambda () 
					      (demo ,(1+ i) ,menu-button 
						    ,exit-button ,tool-button ,disp))
					   (make-title (1+ i)))
				     mlist))))
		 
       		 :query " DEMOS ")))
    
    (setf (menu menu-button) menu)
    
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))
    
    (setf (font disp) (cw:open-font :courier :italic 12 :weight :bold))
    (write-display disp
		   "Welcome to ..."
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp)(my-findfont   22))
    (write-display disp
		   "Automated Theorem Proving"
		   (round (/ (width disp) 12))
		   (- (height disp) 45 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) (scalew 15))
		:bottom (scaleh  15)
		:action `(lambda nil
			   (close-display ,disp)
			   ;;BABBEO
			   ;;  (close-display bibi)
			   (close-display *verbose-disp*)
			   (if ,from-button (reset-button ,from-button))))
    
    (set-button tool-button disp
		:left (round (/ (- (width disp) (width menu-button))2))
		:bottom  (scaleh  15)
		:action `(lambda nil 
			   (disable-button ,exit-button)
			   (disable-button ,menu-button) 
			   (deactivate-display ,disp)            
			   (en)
			   (mp:process-wait "running" 
					    '(lambda nil *execution-terminated*))  
			   (activate-display ,disp)(sleep 1)
			   (reset-button ,tool-button)
			   (enable-button ,exit-button)
			   (enable-button ,menu-button)))
    
    
    (set-button help-button disp 
		:left (scalew 15 )
		:bottom (scaleh 15))
    
    
    (set-button menu-button disp 
		:left (round (/ (- (width disp) (width menu-button)) 2))
		:bottom (scaleh 55))
    disp))


(defun virtual() 
  (setf bibi (make-instance 'display :title "Virtual Screen" :width (scalew 1152)
			    :height  (scaleh 900) :left 0 :bottom 0))
   (cw:draw-filled-rectangle-xy (gin::pattern bibi) 0 0  (scalew 1152) (scaleh 900) :color  cw::50%-gray   )
   (cw:draw-filled-rectangle-xy (gin::window bibi) 0 0  (scalew 1152) (scaleh 900) :color  cw::50%-gray   ))
