;;;======================================================================
;;; -*- Mode:Lisp; Syntax:Common-Lisp; ; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB -  IDSIA  *
;;; ******************************
;;;
;;; Filename:    preproc.cl
;;; Short Desc: preprocessing module:
;;                        Transformation in clauses
;;                        Normalization
;;                        Initialization of the Database
;;                        Classification of clauses
;;                        Initialization of the global variables
;;
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   May 1991
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;



(in-package :atp)

;; Temporary statementes
(setq *all-simplifier* nil)

(setq $equations-in-theorem$ nil)



(defconstant $flag-list$ '($strategy$ 
			   $insert-procedure$
			   $weighting-procedure$
			   $en-p-restr$
			   $precedence-list$
			   $p-resolution$ $resolution$ 
			   $answering$
			   $p-bin-sup$
			   $paramodulation$  
			   $restricted-paramodulation$ 
			   $en-unit$
			   $neg-resolution$
			   $max-wgt$
			   $semantic-simplification$
			   $infix-functor$
			   $postfix-functor$
			   $extended-rewriting$
			   $factoring$
			   $weight-bound$
			   $evaluable$
			   $hyper-p-resolution$
			   $exist-check$
			   $nested-term-weight$
			   $constant-wgt$
			   $backtrack$  
			   $en-backtrack$ 
			   $merge-backtrack$ 
			   $para-backtrack$  
			   $manual-orient$
			   $prolog-mode$
			   $output-format$))
(defparameter *all-simplifier*  nil)
(defparameter $output-format$  'sequent)
(defparameter *interface* nil)
(defparameter *overlap* nil)
(defparameter n-int-var  20000)
(defparameter $user-answer-vars$ nil)
(defparameter  $evaluable-symbols$ '( $IF $OR $ID >= >  + * - / ^
				     $AND $NOT $EQ $LS $READ $WRITE $NL))
(defparameter $insert-procedure$ nil)
(defparameter $strategy$ 'standard)
(defparameter $manual-orient$ nil)
(defparameter $weighting-procedure$ 'rule-wgt) 
(defparameter $hyper-p-resolution$          nil)
(defparameter $p-resolution$                  t)
(defparameter $answering$             nil)
(defparameter $p-bin-sup$              t)
(defparameter $paramodulation$             nil)
(defparameter $restricted-paramodulation$             nil)
(defparameter $neg-resolution$                 t)  
(defparameter $resolution$                 nil)
(defparameter $en-unit$              nil)
(defparameter $factoring$            nil)
(defparameter $exist-check$          t)
(defparameter $backtrack$            t) 
(defparameter $para-backtrack$       t)
(defparameter $en-backtrack$       nil)
(defparameter $merge-backtrack$       nil)
(defparameter $prolog-mode$ nil)
(defparameter $evaluable$ nil)
(defparameter $precedence-list$ nil)
(defparameter $contr$ nil) 
(defparameter $generated-rules$ 0)  (defparameter $unification-attempts$ 0)
(defparameter $semantic-simplification$ nil )
(defparameter $extended-rewriting$ nil)
(defparameter $en-p-restr$ t)
(defparameter $nested-term-weight$ 0)
(defparameter $constant-wgt$ 4)
(defparameter $max-wgt$ 999999999999)
(defparameter $weight-bound$ 10)
(defparameter $infix-functors$ '(= + - < > >=  -> <= =<  * / => <=> &))
(defparameter $postfix-functors$ nil)
(defparameter $infix-functor$ nil)
(defparameter $postfix-functor$ nil)
(defparameter $rules$ nil)
(defparameter $simps$ nil) 
(defparameter $rules-info$ (make-hash-table :size 1000))
(defparameter $rules-bodies$ (make-hash-table :size 1000))
(defparameter *errors-found*  0)
(defparameter $program$ nil)
(defparameter $goal-stack$ nil)
(defparameter $last-clause$ nil)
(defparameter $rule-id 1)

 




;;--------------------------------------------------------------------------------
;; preproc1     : STRING ---> {nil}
;; Behavior     : reads the input file; the input formulas are splitted in axioms and
;;              : set of support. These two sets are put into clausal form. Each clause
;;              : is transformed to a normalized and added to the database
;; Side effects : The prover flags are set to their default values, or according to
;;              : the user declarations. The rule indexes $rules$ $simps$ $rules-info$
;;              : $rules-bodied$ are affected. The variable  $strategy$ is set to
;;              : strategy-object choosen by the user (or by default)


(defun preproc1 (filename)
  (init) 
  (let* (( ax-sos (read-input filename))
	 ( ax  (car ax-sos))
	 ( sos (cdr ax-sos))
	 ( ax-clauses   (mapcan #'preproc-fmla ax))
         ( sos-clauses  (mapcan #'preproc-fmla sos)))
    (init-ch-sets)
    (if $prolog-mode$ (init-prolog-sets))
    (if (not  $insert-procedure$)(setq  $insert-procedure$ (insert-function (eval $strategy$))))
    ;;    (if $insert-procedure$ (setf (insert-function (eval $strategy$))  $insert-procedure$))
    (mapcar #'(lambda (x)(proc-a-clause x 'axiom)) ax-clauses)  
    (mapcar #'(lambda (x)(proc-a-clause x 'sos)) sos-clauses))
  (cond ((> *errors-found* 0) 
	 (l-error (format nil "~D syntax errors were found:~% Execution terminated~%" *errors-found*))))
  
  (setq $max-wgt$ (* $weight-bound$ (max-rule-wgt)))
  (if $prolog-mode$ (prolog-settings))
  (init-choose))
 

(defun preproc-fmla (fmla)
  (let* ((parsed (pars (make-token-list fmla)))
	(res (clausify-main parsed)))
    (cond ((null parsed)
	   (progn (setq *errors-found* (1+ *errors-found*))
	       (warn-error (format nil "Syntax error in formula ~%----->  ~A~%" fmla))))
	  ((null res)(warn-error (format nil "~A is a tautology~%" fmla))))
    res))
    



(defun proc-a-clause (cl label)
 (if (not (null(car cl)))
     (let ((neg-pos (bipart-clause cl)))
       (store  (renvar-for-internal 
		(make-clause (cdr neg-pos) (car neg-pos)))
	       (list label)))))
	    

(defun bipart-clause (cl &optional x y )
  (cond 
   ((null cl) (cons  (reverse x)( reverse y)))
   ((and (listp  (car cl)) (eq '~ (caar cl)))
    (if (is-answer-literal (cadr (car cl)))
	(setq $user-answer-vars$ (cdadr (car cl))))
    (bipart-clause (cdr cl)
		   (append  x (list (cadr (car cl))) )
		   y))
   (t (if (is-answer-literal (car cl)) (setq $user-answer-vars$ (cdar cl)))
      (bipart-clause (cdr cl)
		     x
		     (append y (list  (car cl)))))))

(defun is-answer-literal (at)
  (and (listp at)(eq '$ans  (car at))))

		
	
(defun init()
; (unbind-symbols)
  (init-gsym)  
  (init-r-id) 
  (setq n-int-var  20000)

  (setq  $evaluable-symbols$ '( $IF $OR $ID >= >  + * - /  < > ^
			       $AND $NOT $EQ $LS $READ $WRITE $NL))
  (setq $insert-procedure$ nil)
  (setq $strategy$ 'standard)
  (setq $manual-orient$ nil)
  (setq $weighting-procedure$ 'rule-wgt) 
  (setq $hyper-p-resolution$          nil)
  (setq $p-resolution$                  t)
  (setq $answering$             nil)
  (setq $p-bin-sup$              t)
  (setq $paramodulation$             nil)
  (setq $restricted-paramodulation$             nil)
  (setq $neg-resolution$                 t)  (setq $resolution$                 nil)
  (setq $en-unit$              nil)
  (setq $factoring$            nil)
  (setq $exist-check$          t)
  (setq $backtrack$            t) 
  (setq $para-backtrack$       t)
  (setq $en-backtrack$       nil)
  (setq $merge-backtrack$       nil)
  (setq $prolog-mode$ nil)
  (setq $evaluable$ nil)
  (setq $contr$ nil) 
  (setq $generated-rules$ 0)  (setq $unification-attempts$ 0)
  (setq $semantic-simplification$ nil )
  (setq $extended-rewriting$ nil)
  (setq $precedence-list$ nil)
  (setq $en-p-restr$ t)
  (setq $nested-term-weight$ 0)
  (setq $constant-wgt$ 4)
  (setq $max-wgt$ 999999999999)
  (setq $weight-bound$ 10)
  (setq $infix-functors$ '(= + - < > >=  -> <= =<  * / => <=> &))
  (setq $postfix-functors$ nil)
  (setq $infix-functor$ nil)
  (setq $postfix-functor$ nil)
  (setq $rules$ nil)
  (setq $simps$ nil)
  (setq $rules-info$ (make-hash-table :size 1000))
  (setq $rules-bodies$ (make-hash-table :size 1000))
  (setq *errors-found*  0)
   (setq $output-format$ 'sequent))
  


(defun init-ch-sets ()
  (mapcar #'(lambda (x)(set x nil)) (insert-sets (eval $strategy$))) 
  (mapcar #'(lambda (x)(set x nil)) (delete-sets  (eval $strategy$))))

(defun init-choose()
  (funcall (init-function (eval $strategy$))))
    
(defun init-r-id () 
  (setq $rule-id 1))

(defun new-r-id ()        
  (setq $rule-id (+ 1 $rule-id))
  (- $rule-id 1)) 
(defun retract-r-id () (setq $rule-id (-  $rule-id 1)))

(defun new-clause-id ()
  (atom-conc  'c (new-r-id)))
	      
	      
(defun max-rule-wgt()
  (let ((max 0))
    (mapcar #'(lambda (clause-id)
		 (if (> (size (get clause-id 'info)) max)
		     (setq max (size (get clause-id 'info)))))
	    (append $rules$ $simps$))
    max))





(defun prolog-settings ()
  (setq $strategy$ 'prolog-strat)
  (setq $neg-resolution$ nil)
  (setq $answering$ t)
  (setq $p-resolution$ nil))

(defun init-prolog-sets ()
  (setq $program$ nil)
  (setq $goal-stack$ nil)
  (setq $last-clause$ nil))

 
