;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   prolog.cl
;;; Short Desc: A Prolog interpreter simulator
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)



(defun prolog (filename)
 
  (preproc1 filename)
  (loop
    (prolog-prompt)
    (restore-r-id)
    (setq $goal-stack$ nil)
    (setq $rules$ (cdr $program$))
    (store  (prolog-sem-red (read-query)) '(sos))
    (loop
      (let* ((x-y (prolog-choose))
	     (x (car x-y))(y (cadr x-y)))
	(if (member nil x-y) (return (print  'no)))
	(make-deductions x y)
	(if (contradiction) 
	    (progn 
	      (display-answers)
	      (setq $contr$ nil)
	      (princ " more? ")
	      (if (not (eq (read) 'y)) (return nil))))))))

(defun read-query ()
  (let*
      ((goal-fmla (car (goal  (cons '<= (mkt)))))
       (neg-pos   (bipart-clause (car (clausify-main goal-fmla))))
       (goal-clause  (renvar-for-internal (make-clause nil (car neg-pos))))
       (answer-lit (cons '$ans  (collect-integer-vars 
				 (negative-atoms goal-clause)))))
    (setq $user-vars$ (collect-vars goal-fmla))
    (make-clause nil (append (negative-atoms goal-clause)
			    (list  answer-lit)) )))   
   
   
 

(defun display-bindings ()
  (let ((value-list (cdr (caar (get-rule $contr$))))
	(stream    (if *interface*    *out-disp* t)))
    (format-display *out-disp*
     "~A~%" (bindings-to-string value-list $user-answer-vars$))))
  

(defun bindings-to-string (v u &optional (recursive-call nil))
  (cond ((null v) (if recursive-call "" "yes"))
	(t (concatenate 'string
		  (format nil " ~A = " (tmx-to-string (car u)))
	;;;;;	  (tmx-to-string (sem-reduce (car v)))
		   (tmx-to-string  (car v))
		  (string #\newline)
		  (bindings-to-string (cdr v)(cdr u) t)))))

(defun restore-r-id () 
  (setq $rule-id (1+ (read-from-string
		      (string-left-trim '(#\c #\C) $last-clause$)))))

(defun prolog-prompt ()
  (nl)(princ "|? "))
 
