;;; -*- Mode: LISP; Package: atn; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atn-demo1.cl
;;; Short Desc: First demo on Augmented Transition Networks
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   28.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atn)


;;=====================================================================
;; The definition of demo1
;;=====================================================================


(defun demo-1 ( )
   (setq *demo-in-execution* 1)
  (format-display-fill demo-text-disp (format nil  
		   "~%Here is a first demo on augmented 
transition networks. Push <continue> to
load the ATN module"))
  (when (wait)
  (atn-tool)
  (protect-display *atn-tool-window* t)
  (protect-display *atn-output-window* t)
  (protect-display *step-window* t)
  (format-display-fill demo-text-disp (format nil  
		   "~%Now we select the current net
and the current lexicon
"))
  (when (wait)
  (set-net (add-path "networks/net-1" *atn-path*))
  (set-lex (add-path "lexicae/lex-1" *atn-path*))
   (format-display-fill demo-text-disp (format nil  
		   "~%Here is a sample of how the
user can specify a lexicon"))
    (when (wait)
   
   (setq *view* (make-instance 'help-display
			    :left   (left *atn-output-window*)
			    :bottom (scalew 50)
			    :height (scaleh 400)
			    :width  (scalew 800)
			    :filename  (add-path "lexicae/lex-1" *atn-path*)))
   (protect-display *view* t)  
  (format-display-fill demo-text-disp (format nil  
		   "~%Here is a sample of how the
user can specify a transition net."))
    (when (wait)
       (close-display *view*)
    (setq *view* (make-instance 'help-display
			    :left   (left *atn-output-window*)
			    :bottom (scalew 50)
			    :height (scaleh 400)
			    :width  (scalew 800)
			    :filename  (add-path "networks/net-1" *atn-path*)))
    (protect-display *view* t)
    
      (format-display-fill demo-text-disp (format nil  
		   "~%The <Graphic> button toggles
a graphic simulation of the transition
network. Now you can see the correspondence 
between the formal specification of the
network and its graphical representation.
"))
  (when (wait)  
  (when (wait)
  (my-software-push *graph-button* *atn-tool-window* )
  (format-display-fill demo-text-disp (format nil  
		   "~%The user can write a sentence to
be parsed by the current network, for
instance :
Paolo sees that Luca eats a pizza
"))
   (when (wait)
    (close-display *view*)
   (format-display *sentence-window* 
		  "Paolo sees that Luca eats a pizza")
  (setq *last-sentence* "Paolo sees that Luca eats a pizza")

    (format-display-fill demo-text-disp (format nil  
		   "~%The <Step> button allows the user to
follow the  parsing process one step 
at time.
"))
  (when (wait) 
  (my-software-push *step-button* *atn-tool-window* )  (sleep .5)
   (format-display-fill demo-text-disp (format nil  
		   "~%Variuos levels of verbosity in
the output can be selected with the
<debug> and <trace> buttons
"))
  (when (wait)      
  (my-software-push *diag-button* *atn-tool-window* ) (sleep .5)
  (my-software-push *diag-button* *atn-tool-window* ) (sleep .5)
  (my-software-push *diag-button* *atn-tool-window* ) (sleep .5)
  (my-software-push *diag-button* *atn-tool-window* ) (sleep .5)
  
  (my-software-push *trace-button* *atn-tool-window* ) (sleep .5)
  (my-software-push *trace-button* *atn-tool-window* ) (sleep .5)
  (my-software-push *trace-button* *atn-tool-window* ) (sleep .5)
  (my-software-push *trace-button* *atn-tool-window* ) (sleep .5)
  (my-software-push *trace-button* *atn-tool-window* ) (sleep .5)
   (format-display-fill demo-text-disp (format nil  
		   "~%The <Parse Current Sentence> button
starts the parsing algorithm. When the
graphical output is set on, a hopping
cursor displays the currently active 
node of the network. 


"))
  (when (wait)   
    (my-software-push *step-button* *atn-tool-window* )  
  (my-software-push *parse-sentence-button* *atn-tool-window* )
      (format-display-fill demo-text-disp (format nil  
		   "~%In the case one parse has been 
found. The next sentence is not
correct for the current network:
Paolo  Luca eats a pizza
"))
 (when (wait)  
 (setq *last-sentence* "Paolo  Luca eats a pizza")
 (format-display *sentence-window*  *last-sentence* )
 (format-display-fill demo-text-disp (format nil  
		   "~%We parse the sentence:
"))
    (when (wait)  
  (my-software-push *parse-sentence-button* *atn-tool-window* ) 
  (format-display-fill demo-text-disp (format nil  
		   "~%This sentence has not been
recognized. 
There are also some buttons
useful to inspect the state of the
conputation. "))
 (when (wait)  
 (format-display-fill demo-text-disp (format nil  
		   "~%
The <Regs> button prints the values
of the registers defined in the current
scope.

The <Hold> button prints the value
of the HOLD  register

The <Stack> button prints the 
current content of the stack.
Let's push, for example, the <Stack>
button
"))
   (when (wait)  
       (my-software-push *stack-button* *atn-tool-window* )
     (format-display-fill demo-text-disp (format nil  
		   "~%This is the end of the first demo"))
  (when (wait)  
  (my-software-push *exit-tool-button* *atn-tool-window* )))))))))))))))))