;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;  AUGMENTED TRANSITION NETWORKS
;;; ************************************************************************
;;;
;;; Filename:   atn-demo2.cl
;;; Short Desc: Second demo on Augmented Transition Networks
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   28.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atn)


;;=====================================================================
;; The definition of demo2
;;=====================================================================


(defun demo-2 ( )
   (setq *demo-in-execution* 2)
  (format-display-fill demo-text-disp (format nil  
		   "~%Here is a second demo on augmented 
transition networks. 
Push <continue> to load the ATN module"))
  (when (wait)
  (atn-tool)
  (protect-display *atn-tool-window* t)
  (protect-display *atn-output-window* t)
  (protect-display *step-window* t)
  (format-display-fill demo-text-disp (format nil  
		   "~%Now we select net-5  as the current net
and lex-2 as current lexicon"))

  (when (wait)
  
  (set-net (add-path "networks/net-5" *atn-path*))
  (set-lex (add-path "lexicae/lex-2" *atn-path*))
  (format-display-fill demo-text-disp (format nil  
		   "~%Here is the user definition for net-5."))
    (when (wait)
    (setq *view* (make-instance 'help-display
			    :left   (left *atn-output-window*)
			    :bottom (scaleh 50)
			    :height (scaleh 400)
			    :width  (scalew 1100)
			    :filename  (add-path "networks/net-5" *atn-path*)))
    (protect-display *view* t) 
    (format-display-fill demo-text-disp (format nil  
		   "~%This network is designed to handle
interrogatives, passive sentences and 
some auxiliary verbs. Its output is
a logical analisis of the given  sentence.
This network makes use of registers, so
it is a true augmented transition network
while net-1 was in fact a simple recursive 
transition network.
"))
 
    
     (format-display-fill demo-text-disp (format nil  
		   "~%Here is the definition of lex-2"))
    (when (wait)
    (close-display *view*)
   (setq *view* (make-instance 'help-display
			    :left   (left *atn-output-window*)
			    :bottom  (scaleh 50)
			    :height (scaleh 400)
			    :width  (scalew 1100)
			    :filename  (add-path "lexicae/lex-2" *atn-path*)))
   (protect-display *view* t)  
    
  (format-display-fill demo-text-disp (format nil  
		   "~%Notice that this lexicon is much
more complicated than the one in lex-1"))
   (when (wait)
    (close-display *view*)
   (format-display *sentence-window* 
		  "Is a pizza eaten by the man in the restaurant?")
  (setq *last-sentence*   "Is a pizza eaten by the man in the restaurant?")
  (format-display-fill demo-text-disp (format nil  
		   "~%Now we turn the graphic layout on 
"))
  (when (wait)  
  (my-software-push *graph-button* *atn-tool-window* )
 (format-display-fill demo-text-disp (format nil  
		   "~%We also set the <trace> mode 
"))
  (my-software-push *trace-button* *atn-tool-window* ) (sleep .5)
   (format-display-fill demo-text-disp (format nil  
		   "~%The <Parse Current Sentence> button
starts the parsing algorithm. When the
graphical output is set on, a hopping
cursor displays the currently active 
node of the network. 


"))
  (when (wait)   
  (my-software-push *parse-sentence-button* *atn-tool-window* )
  (format-display-fill demo-text-disp (format nil  
		   "~%To make the parsing faster
you can turn off the graphic output
and the tracing."))
    (when (wait)
        (my-software-push *graph-button* *atn-tool-window* )(sleep .5)
        (my-software-push *trace-button* *atn-tool-window* ) (sleep .5)
     (format-display-fill demo-text-disp (format nil  
		   "~%Now we parse the sentence
"))
    )
  (when (wait)   
  (my-software-push *parse-sentence-button* *atn-tool-window* )
   
  (format-display-fill demo-text-disp (format nil  
		   "~%The present network is designed to
output a logical analysis of the
given sentence once a parse is found.
The kind of output you can see in the
ATN:output display is determined by 
the user who designed the network.
In this case the parser descovered that
the sentence is a question, that the
tense is present, that the subject is
the man and so on. Notice that, since
the interpretation of the sentence is
ambiguous, the atn generates two different
parses. 
"))
 (when (wait)  
  (format-display-fill demo-text-disp (format nil  
		   "~%We can give a look to the state
of the registers, pushing <Registers>"))
   (when (wait)  
       (my-software-push *regs-button* *atn-tool-window* )
     (format-display-fill demo-text-disp (format nil  
		   "~%Remember that you can inspect the
state of the registers at any point 
of the parsing process, using the
<step> mode."))
  (when (wait)    
  (format-display-fill demo-text-disp (format nil  
		   "~%**This is the end of the second demo**"))
  (when (wait)  
  (my-software-push *exit-tool-button* *atn-tool-window* ))))))))))))))