;;; -*- Mode: LISP; Package: atn; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;  AUGMENTED TRANSITION NETWORKS
;;; ************************************************************************
;;;
;;; Filename:   atn-demo3.cl
;;; Short Desc:  third demo on Augmented Transition Networks
 ;;; Version:    1.0
 ;;; Status:     Review
 ;;; Last Mod:   28.9.91 - FB
 ;;; Author:     Fabio Baj
 ;;;
 ;;; --------------------------------------------------------------------------
 ;;; Change History:
 ;;;
 ;;;
 ;;; --------------------------------------------------------------------------

 
 ;;; ==========================================================================
 ;;; PACKAGE DECLARATIONS
 ;;; ==========================================================================
 (in-package :atn)


 ;;=====================================================================
 ;; The definition of demo2
 ;;=====================================================================


(defun demo-3 ( )
  (setq *demo-in-execution* 3)
  (format-display-fill demo-text-disp (format nil  
					      "~%Here is a third demo on augmented 
 transition networks. You will see
 how to integrate the ATN module
 with the theorem proving one. 
 The network net-6 and lexicon lex-3
 define a parser which translates a
 subset  of english sentences into first
 order logic formulas, which can be given 
 as input to the theorem proving module.
 Push <continue> to load the ATN module"))
  (when (wait)
    (atn-tool)
    (protect-display *atn-tool-window* t)
    (protect-display *atn-output-window* t)
    (protect-display *step-window* t)
    (format-display-fill demo-text-disp (format nil  
						"~%Now we select net-6  as the current net
and lex-3 as current lexicon"))
    
    (when (wait)
      
      (set-net (add-path "networks/net-6" *atn-path*))
      (set-lex (add-path "lexicae/lex-3" *atn-path*))
      (format-display-fill demo-text-disp (format nil  
						  "~%Here is the user definition for net-6."))
      (when (wait)
	(setq *view* (make-instance 'help-display
		       :left   (left *atn-output-window*)
		       :bottom (scaleh 50)
		       :height (scaleh 400)
		       :width (scalew 1100)
		       :filename  (add-path "networks/net-6" *atn-path*)))
	(protect-display *view* t) 
	(format-display-fill demo-text-disp (format nil  
						    "~%This network is able to transform"))
	(format-display-fill demo-text-disp (format nil  "sentences like  "))
	
	(format-display-fill demo-text-disp
			     (format nil  "------------------------ "))
	(format-display-fill demo-text-disp
			     (format nil  "luca loves every woman which does not like a man "))
	
	(format-display-fill demo-text-disp
			     (format nil  "------------------------ "))
	(format-display-fill demo-text-disp (format nil "into first oder formulas like"))
	
	(format-display-fill demo-text-disp
			     (format nil  "------------------------ "))
	(format-display-fill demo-text-disp (format nil " all x2  ((Woman(x2) & ~~ exists x3  
(Man(x3) & Like(x2,x3))) => Love(luca,x2))."))
(format-display-fill demo-text-disp
			     (format nil  "------------------------ "))
(format-display-fill demo-text-disp (format nil  "
Then the Theorem Proving module can be
used to make deductions about the semantic
content of the sentences."))
    
(format-display-fill demo-text-disp (format nil  
					    "~%Here is the definition of lex-3"))
(when (wait)
  (close-display *view*)
  (setq *view* (make-instance 'help-display
		 :left   (left *atn-output-window*)
		 :bottom  (scaleh 50)
		 :height  (scaleh 400)
		 :width   (scalew 1100)
		 :filename  (add-path "lexicae/lex-3" *atn-path*)))
  (protect-display *view* t)  
  
  (when (wait)
    (close-display *view*)
    (format-display-fill demo-text-disp (format nil 
						"~%Now we type a simple sentence to be parsed:
    Paolo likes a woman who does  not 
    love a man which owns a car
it is displayed in the ATN:Current Sentence 
window"))
    (format-display *sentence-window* 
		    "Paolo likes a woman who does not love a man which owns a car")
    (setq *last-sentence*   "Paolo likes a woman who does not love a man which owns a car" )
    (format-display-fill demo-text-disp (format nil  
						"~%Turning the graphic layout on:
"))
    (when (wait)  
      (my-software-push *graph-button* *atn-tool-window* )
      (format-display-fill demo-text-disp (format nil  
						  "~%The <Parse Current Sentence> button
starts the parsing algorithm. When the
graphical output is set on, a hopping
cursor displays the currently active 
node of the network. 

"))
      (when (wait)   
	(my-software-push *parse-sentence-button* *atn-tool-window* )
	
	(format-display-fill demo-text-disp (format nil  
						    "~%The output window shows the first
order formula representing the meaning
of the input sentence. The network
is designed to direct the output 
formulas also to a theorem file, 
[*pail-path*]/atp/examples/AtnOut.th
which can be loaded with the ATP module.
For instance  you can use the ATP module
to check the consistency of a set of 
sentences, or to see if a sentence is
logical consequence of a set of premises
"))
	(when (wait)  
	  (format-display-fill demo-text-disp (format nil  
						      "~%**This is the end of the second demo**"))
	  (when (wait)  
	    (my-software-push *exit-tool-button* *atn-tool-window* )))))))))))
