
;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo.cl
;;; Short Desc: general dialog handling for DEMOS on the theorem prover
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)




;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================


(defvar *pause* nil)
(defvar *quit* nil)




;;============================================================================
;; DEMO FUNCTION: Runs the demo numbered nr
;;; ==========================================================================

(defun auto-demo (nr    )
  (let ((disp (make-instance 'display :title (concatenate 'string "ATP:" (make-title-w  nr))
			    :width *default-width*
			    :height (scalew 260)
			    :borders 1
			    :left *default-left* 
			    :bottom (scaleh 598))))
    (setf demo-exit-button 
      (make-instance 'push-button :font (my-findfont 13):label "Exit" :width (scalew  180)))
    (setf demo-help-button 
      (make-instance 'help-button :label "Help"  :font (my-findfont 13) :width (scalew 180) 
		     :subject (concatenate 'string "Demo " (format nil "~A" nr))
		     :technical  
		     (add-path "atp-demo-desc.asc" *len-directory*)
		     :general 
		     (add-path 
		      (concatenate 'string
			"atp-demo" (format nil "~A" nr )"-desc.asc") *len-directory*)))
    (setf demo-start-button (make-instance 'push-button :label "Start" :font (my-findfont 13) :width (scalew 180)))
    (setf demo-cont-button (make-instance 'push-button :label "Continue"  :font (my-findfont 13) :width (scalew  180)))
   
    ;;    (setf (font disp)  (cw:open-font :courier :italic 16.5 :weight :bold))
   (setf (font disp) (my-findfont 16.5))
    (write-display disp 
		   (make-title nr)
		   (scalew 15) (- (height disp) (scaleh 15) (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    
    
    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) (scalew 15))
	       (- (height disp) (cw:bitmap-height *pail-logo*)(scaleh 15)))
    
    (setf demo-text-disp (make-instance
			   'scroll-display
			  :title "ATP:Comments"
			  :font (open-font-named "fixed")
			  :parent disp
			  :width  (scalew 420)
			  :height  (scaleh 230)
			  :borders 1
			  :left (- (width disp) (scalew 530))
			  :bottom (- (height disp) (scaleh 274))))
    
    (set-button demo-exit-button disp 
		:left (scalew 40)
		:bottom (scaleh 15)
		:action `(lambda ()
			   (setf *quit* t) (sleep 0.2)
			   (dolist (d *open-displays-list*)
			     (close-display (eval d)))
			   (setq *open-displays-list* nil)
			   (setq *demo-in-execution* nil)
			   (setq *theorems-dir* 
			     (add-subdir *len-directory* *theorems-subdir*))
			   (close-display ,disp)
			   (sleep 0.2)
			   
			   ))
    
    (set-button demo-help-button disp 
		:left (scalew 40)
		:bottom (scaleh 50))
		
    
    (set-button demo-start-button disp 
		:left (scalew 40)
		:bottom (scaleh 85)		:action
		#'(lambda ()
		    (disable-button  demo-start-button)
		    (reset-button  demo-start-button)
		    (disable-button demo-exit-button)
		    (auto-handler nr)))
    
    (set-button demo-cont-button disp 
		:left (scalew 40)
		:bottom (scaleh 120)
		:action 
		#'(lambda ()
		    (disable-button demo-exit-button)
		    (setf *pause* t)))
      ( disable-button  demo-cont-button)
    

      (setf pail::*stop-demo* nil)
      (software-push demo-start-button)
      (software-push demo-exit-button)
      
    ))





(defun dialog-handler(nr)
  (labels ((clean-up ()
	       (close-display demo-text-disp)
	       (unless *quit*
		 (enable-button demo-exit-button)
		 (reset-button demo-cont-button)
		 (disable-button demo-cont-button)
		 (reset-button demo-start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button demo-cont-button)
	  (reset-button demo-cont-button)
	  (enable-button demo-exit-button)
	  (format-display demo-text-disp "~%<Continue>")
	  (mp:process-wait "wait-on-click" (function (lambda () (or *quit* *pause*))))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol(string
				  (read-from-string 
				   (format nil "demo-~a" nr))) :atp)))
	(if fun-sym
	    (funcall fun-sym )(progn
				(format t "Demo not implemented")
				(wait)
				(clean-up))))
      (clean-up)))

(defun demo (nr menu-button other-exit-button tool-button maindisp)
  (deactivate-display maindisp)
  (disable-button menu-button)
  (disable-button other-exit-button)
  (disable-button tool-button)
  (let ((disp (make-instance 'display :title (concatenate 'string "ATP:" (make-title-w  nr))
			     :width *default-width*
			     :height (scaleh 280)
			     :borders 1
			     :left *default-left* 
			     :bottom (scaleh 600))))
    (setf demo-exit-button 
      (make-instance 'push-button  :font (my-findfont 13) :label "Exit" :width (scalew 180)))
    (setf demo-help-button 
      (make-instance 'help-button :label "Help" :width (scalew 180) :font (my-findfont 13)
		     :subject (concatenate 'string "Demo " (format nil "~A" nr))
		     :technical  
		     (add-path "atp-demo-desc.asc" *len-directory*)
		     :general 
		     (add-path 
		      (concatenate 'string
			"atp-demo" (format nil "~A" nr )"-desc.asc") *len-directory*)))
    (setf demo-start-button (make-instance 'push-button :label "Start"  :font (my-findfont 13) :width (scalew 180)))
    (setf demo-cont-button (make-instance 'push-button :label "Continue"  :font (my-findfont 13) :width (scalew 180)))
    
    ;;   (setf (font disp) (cw:open-font :courier :italic 16.5 :weight :bold))  
    (setf (font disp) (my-findfont 16.5))
    (write-display disp 
		   (make-title nr)
		   (scalew 15) (- (height disp) (scaleh 5) (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    
    
    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) (scalew 10))
	       (- (height disp) (cw:bitmap-height *pail-logo*) (scaleh 10)))
    
    (setf demo-text-disp (make-instance
			     'scroll-display
			   :title "ATP:Comments"
			   :font (my-findfont 12)
			   :parent disp
			   :width (scalew  480)
			   :height (scaleh 230)
			 :borders 1
			 :left (- (width disp) (scalew 610))
			 :bottom (- (height disp) (scaleh 274))))
    
    (set-button demo-exit-button disp 
		:left (scalew 40)
		:bottom (scaleh 15)
		:action `(lambda ()
			   (setf *quit* t) (sleep 0.2)
			   (dolist (d *open-displays-list*)
			     (close-display (eval d)))
			   (setq *open-displays-list* nil)
			   (setq *demo-in-execution* nil)
			   (setq *theorems-dir* 
			     (add-subdir *len-directory* *theorems-subdir*))
			   (close-display ,disp)
			   (activate-display ,maindisp)
			   (sleep 0.2)
			   (print (font ,menu-button))
			   (enable-button ,menu-button)
			   (enable-button ,other-exit-button)  
			   (enable-button ,tool-button)
			   
			   ))
    
    (set-button demo-help-button disp 
		:left (scalew 40)
		:bottom (scaleh 50))
		
    
    (set-button demo-start-button disp 
		:left (scalew 40)
		:bottom (scaleh 85)		:action
		#'(lambda ()
		    (disable-button  demo-start-button)
		    (reset-button  demo-start-button)
		    (disable-button demo-exit-button)
		    (dialog-handler nr)))
    
    (set-button demo-cont-button disp 
		:left (scalew 40)
		:bottom (scaleh 120)
		:action 
		#'(lambda ()
		    (disable-button demo-exit-button)
		    (setf *pause* t)))
      ( disable-button  demo-cont-button)
    
    ))




(defun auto-handler(nr)
  (labels ((clean-up ()
	       (close-display demo-text-disp)
	       (unless *quit*
		 (enable-button demo-exit-button)
		 (reset-button demo-cont-button)
		 (disable-button demo-cont-button)
		 (reset-button demo-start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button demo-cont-button)
	  (reset-button demo-cont-button)
	  (enable-button demo-exit-button)
	  (format-display demo-text-disp "~%<Continue>")
	  (sleep 1)
	  (mp:process-wait "wait-on-click" (function (lambda () (not pail::*pause-demo*))))
	  (if pail::*stop-demo* (software-push demo-exit-button))
	  (software-push demo-cont-button)
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol(string
				  (read-from-string 
				   (format nil "demo-~a" nr))) :atp)))
	(if fun-sym
	    (funcall fun-sym )(progn
				(format t "Demo not implemented")
				(wait)
				(clean-up))))
      (clean-up)))



(defun choose-file-demo (nr)
  (funcall (find-symbol (symbol-name (read-from-string (format nil "choose-file-demo-~a" nr))) :atp)))
(defun display-settings-demo (nr)
 (funcall (find-symbol (symbol-name (read-from-string (format nil "display-settings-demo-~a" nr))) :atp)))
(defun more-solutions-demo (nr)
 (funcall (find-symbol (symbol-name (read-from-string (format nil "more-solutions-demo-~a" nr))) :atp)))
(defun read-query-from-window-demo (nr)
 (funcall (find-symbol (symbol-name (read-from-string (format nil "read-query-from-window-demo-~a" nr))) :atp)))



(defun make-title (nr)
  (format nil "A ~:R Demo on~%    Automated~%      Theorem~%      Proving" nr))

(defun make-title-w (nr)
  (format nil "A ~:R Demo on Automated Theorem Proving" nr))



