;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo1.cl
;;; Short Desc: First demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo1.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)


;;=====================================================================
;; The definition of demo1
;;=====================================================================


(defun demo-1 ( )
  (setq *right-solution* nil)
  (setq *theorems-dir* *len-directory*)
  (setq *demo-in-execution* 1)
  (format-display-fill demo-text-disp  (format nil
		   "~%Here is a first demo on automated theorem proving
"))
  (when (wait)
  (format-display-fill demo-text-disp (format nil
		   "~%Let us suppose we are given the following problem:

The killer, a person who lives in the castle  killed 
Agatha. Agatha, Butler and  Charles live in the castle,
and nobody else. Everyone who kills someone hates him 
and is not richer than him. Charles does not hate who 
is hated by Agatha, who hates everyone but Butler. 
Butler hates everyone who is not richer than Agatha;
He also hates everyone is hated by Agatha. 
Everybody hates somebody. Agata is not Butler.
Who killed Agatha?

"))
  (when (wait)
  (format-display-fill demo-text-disp (format  nil 
		   "~%To use a theorem proving system to solve problems
one must specify it in the language of First Order 
Logic. Here is for example the logical specification
of the above puzzle"))
  (when (wait)
  (print-agata)
  (when (wait)
  (format-display-fill demo-text-disp (format  nil  "~%The ATP tool has an answer extraction mechanism
so in some cases you can ask questions about objects.
For instance the question 'Who killed Agatha' can be represented
by the formula:

(the_murderer killed Agatha) => ?(the_murderer).

"))

  (when (wait)
  (format-display-fill demo-text-disp (format nil  "~%Now we can call the theorem proving tool"))
  (when (wait)
  (en)
  (protect-display *main-disp* t)
  (protect-display *out-disp* t)
  (protect-display *dialog-disp* t)
 (format-display-fill demo-text-disp  (format nil  "~%The <LOAD THEOREM> button loads a theorem file
"))
  (when (wait)
  (my-software-push *load-file-button* *main-disp*)
  (enable-the-right-buttons)
  (format-display-fill demo-text-disp (format nil  "~%Notice that when a theorem is loaded
its formulas are transformed in clauses. There are three 
different output formats for clauses: 
- sequent format
- clause  format
- Prolog  format"))
 (format-display-fill   demo-text-disp  (format nil  "~%The user can set the output format by pushing
 the button <Display Settings>"))
  (when (wait)
  (my-software-push *display-setting-button*  *main-disp*)
 
  ;; TRAP TO demo-display-setting-1
  
  (format-display-fill demo-text-disp (format nil  "~%Pushing the <List Database> button the 
above formulas will be displayed in clausal format
"))
  (when (wait)
  (my-software-push *list-db-button* *main-disp*)
  (format-display-fill demo-text-disp (format  nil  "~%Now it is time to ask the prover to prove
the theorem. In this case the question answering system 
will find the correct answer to the question
'who killed Agatha?'
we push the <Prove Theorem> button
"))	  
  (when (wait)
  (my-software-push *proof-th-button* *main-disp*)
  (write-display *dialog-disp*  "the_murderer = Agatha" 10 10)
 (format-display-fill demo-text-disp  (format nil  "~%The prover has found that Agatha\'s  murderer 
is Agatha itself.
Many of the generated clauses are not really useful:
we can ask the prover to show only the clauses
used to deduce the answer pushing <Show Proof>
"))
  (when (wait)
  (my-software-push *show-proof-button* *main-disp*)
 (format-display-fill demo-text-disp  (format nil  "~%The button <Show Proof Tree> graphically displays
the proof tree. The root is the last clause generated
(an answering clause or a contradiction) and the leafs
are the initial axioms
" ))
  (when (wait)
  (my-software-push *show-proof-tree-button* *main-disp*)
  (setq *open-displays-list* (push *browser-disp*  *open-displays-list* ))
 (format-display-fill demo-text-disp  (format nil  "~%Pushing on the labels of the prof tree
you can see the correspondent formula. 
Press continue to close the browser.
"))
  (when (wait)
  (close-display *browser-disp*)
  (format-display-fill demo-text-disp (format nil  "~%Now we close the theorem proving tool~%"))
  (when (wait)
 (format-display-fill demo-text-disp  (format nil "~%******* End of the first DEMO ********"))
  (close-display *main-disp*)
  (close-display *out-disp* )
  (close-display *dialog-disp*))))))))))))))))
  
      
      
(defun print-agata ()
   (format-display-fill demo-text-disp (format nil " (The_killer killed Agatha)."))
  (format-display-fill demo-text-disp (format nil " (The_killer lives_in_the_castle)."))
  (format-display-fill demo-text-disp (format nil " (Agatha lives_in_the_castle)."))
  (format-display-fill demo-text-disp (format nil " (Butler lives_in_the_castle)."))
  (format-display-fill demo-text-disp (format nil " (Charles lives_in_the_castle)."))
  (format-display-fill demo-text-disp (format nil " (x lives_in_the_castle) => "))
   (format-display-fill demo-text-disp (format nil "       (x = Agatha) | (x = Butler) | (x = Charles)."))
  (format-display-fill demo-text-disp (format nil " (x killed y ) => (x hates y)."))
  (format-display-fill demo-text-disp (format nil " (x killed y) => ~~(x is_richer_than y)."))
  (format-display-fill demo-text-disp (format nil " (Agatha hates x) => ~~ (Charles hates x)."))
  (format-display-fill demo-text-disp (format nil " ~~(x = Butler) =>  (Agatha hates x)."))
  (format-display-fill demo-text-disp (format nil " ~~(x is_richer_than Agatha) => (Butler hates x)."))
  (format-display-fill demo-text-disp (format nil " (Agatha hates x) => (Butler hates x)."))
  (format-display-fill demo-text-disp (format nil " all x exists y ~~ (x hates y)."))
  (format-display-fill demo-text-disp (format nil " ~~(Agatha = Butler).")))


(defun more-solutions-demo-1()
  (if(not *right-solution*)
	  (setq *right-solution* t)))
	 
	
(defun choose-file-demo-1 ()
  "atp-demo1.th")
  
(defun display-settings-demo-1 ()
  (protect-display set-disp  t)
  (format-display-fill demo-text-disp (format  nil  "~%Now we change from Sequent format to Clause format
"))
  (when (wait)
 
  (my-software-push *sequent-format-but* set-disp)
  (my-software-push *clause-format-but* set-disp)
  (when (wait)
  (my-software-push *exit-disp-set-but* set-disp))))