;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo2.cl
;;; Short Desc: Second demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo2.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)



;;=====================================================================
;; The definition of demo2
;;=====================================================================


(defun demo-2 ( )
  (sleep 1)
  (setq *theorems-dir*  *len-directory* )
  (setq *demo-in-execution* 2)
  (format-display demo-text-disp 
		  "~%Here is a second demo about automated theorem proving")
  (when (wait)
  (format-display-fill demo-text-disp (format nil  
		   "~%In this demo we want to use a theorem prover to
investigate a property of natural numbers.
This property says that for every prime number we have that
either its successor or its predecessor is divisible by 6.
To state whether this sentence about numbers is true or not
we must formalize the problem in the language of logic. 
The theorem prover is refutational, so to prove a theorem we
must negate it and try to obtain a contradiction."))
  (when (wait)
  (format-display-fill demo-text-disp (format nil  
		   "~%The theorem can be stated in a input file which
will be read by the prover. Now you will see a tipical
input file of the theorem proving module."))
  (when (wait)
  (format-display-fill demo-text-disp (format nil  
		   "~%"))
    
 (setq *view* (make-instance 'help-display
			    :left (scalew 10)
			    :bottom (scaleh  50)
			    :height  (scaleh 400)
			    :width (scalew 800)
			    :filename  (add-path "atp-demo2.th"*len-directory*)))
    (protect-display *view* t)
  
  (format-display-fill demo-text-disp (format nil   "~%Now we can call the theorem proving tool"))
  (push *view* *open-displays-list*)
  (when (wait)
  (en)
  (push *view* *open-displays-list*)
  (protect-display *main-disp* t)
  (protect-display *out-disp* t)
  (protect-display *dialog-disp* t) 
   (format-display-fill demo-text-disp (format nil   "~%The <Load Theorem> button loads the theorem file
"))
  (when (wait)
  (my-software-push *load-file-button* *main-disp*)
  (format-display-fill demo-text-disp (format nil   "~%The theorem proving module allows the user
to select among different theorem proving approaches:
there is the possibility to enable inference rules like
resolution, factoring, paramodulation, rewriting or
SLD-resolution (Prolog), as well as different search strategies.
The <Display Settings> button shows which options are selected
for the current theorem"))
  (when (wait)
  (my-software-push *display-setting-button*  *main-disp*)
 ;; TRAP TO demo-display-setting-2
  
  
  
  
  
  
  (format-display-fill demo-text-disp (format nil   "~%To prove the theorem we must push the
<Prove Theorem> button"))
   (when (wait) 
  (my-software-push *proof-th-button* *main-disp*)
  (format-display-fill demo-text-disp (format nil   "~%Since the prover succeded to generate the empty clause
(contradiction) at clause c31, we can deduce that our conjecture 
about prime numbers is valid"))
  (when (wait)
 (format-display-fill demo-text-disp (format nil   "~%Here is the complete proof"))
  (my-software-push *show-proof-button* *main-disp*) 
  (when (wait)
 (format-display-fill demo-text-disp (format nil   "~%Here is the proof tree"))
  (my-software-push *show-proof-tree-button* *main-disp*)
    (setq *open-displays-list* (push (display *browser-disp*)  *open-displays-list* ))
  (format-display-fill demo-text-disp (format nil   "~%Push <Continue> to close the browser")) 
  (when (wait)
  (close-display *browser-disp*) 
  (format-display-fill demo-text-disp (format nil  "~%******* End of the second DEMO ********"))
  (sleep 2)  
  (close-display *main-disp*)
  (close-display *out-disp* )
  (close-display *dialog-disp*))))))))))))

;;===============================================================

(defun choose-file-demo-2 ()
  "atp-demo2.th")
  
(defun display-settings-demo-2 ()
  (protect-display set-disp  t)
  (format-display-fill demo-text-disp (format nil   "~%We want to prove this theorem using the resolution
method and a 'set-of-support' strategy, so we push
the appropriate buttons
"))
  (when (wait)
    (my-software-push  *p-resolution-but*  set-disp)     (sleep 0.8)
    (my-software-push *neg-resolution-but*  set-disp)    (sleep 0.8)
    (my-software-push *resolution-but*  set-disp)        (sleep 0.8)
    (my-software-push *standard-strategy-but*  set-disp)    (sleep 0.8)
    (my-software-push *sos-strategy-but*  set-disp)
    (format-display-fill demo-text-disp (format nil   "~%Now we push the <  OK  > button
"))
    (when (wait)
      (my-software-push *exit-disp-set-but* set-disp))))