;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo3.cl
;;; Short Desc: Third demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo3.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)


;;=====================================================================
;; The definition of demo3
;;=====================================================================
  
  
(defun demo-3 ( )
  (setq *right-solution* 0)
  (setq *exit-user-query* nil)
  (setq *theorems-dir*  *len-directory*)
  (setq *demo-in-execution* 3)
  (format-display-fill demo-text-disp (format nil  
		   "~%Here is a third demo on automated theorem proving:
It shows how a theorem proving system can be used
like a Prolog interpreter. Since a pure Prolog system is
nothing more than a restricted theorem prover with
answering system, is is possible to use this prover to
execute Prolog programs exactly in the same way a typical
Prolog interpreter does. Furthermore some non-logical
feature of real Prolog like the cut is also available.

"))
 (when (wait)
 (format-display-fill demo-text-disp (format nil   
		   "~%Now you will see a Prolog program which solves
the problem of finding paths in a maze. This program uses
typical prolog features like negation as failure and cut.
Notice that you are allowed to specify Prolog programs
using the standard prolog syntax"))
  (when (wait)
  (setq *view* (make-instance 'help-display
			    :left (scalew 10)
			    :bottom (scaleh 50)
			    :height (scaleh 400)
			    :width (scalew 800)
			  :filename  (add-path "atp-demo3.th"*len-directory*)))
    (protect-display *view* t)
   
  (format-display-fill demo-text-disp (format nil   "~%Now we call the theorem proving tool"))
   (push *view*  *open-displays-list* )
   (when (wait)
  (en)
  (push *view*  *open-displays-list* )
  (protect-display *main-disp* t)
  (protect-display *out-disp* t)
  (protect-display *dialog-disp* t)
  (format-display-fill demo-text-disp (format nil   "~%The <LOAD THEOREM> button loads the theorem file
"))
  (when (wait)
  (my-software-push *load-file-button* *main-disp*)
  (enable-the-right-buttons)
  (format-display-fill demo-text-disp (format nil   "~%You can display the clauses using the prolog format"))
  (when (wait)
  (my-software-push *display-setting-button*  *main-disp*)
 
  ;; TRAP TO demo-display-setting-3
  
  (format-display-fill demo-text-disp (format nil   "~%Pushing the <List Database> button the 
above formulas will be displayed in prolog format
"))
  (when (wait)
  (my-software-push *list-db-button* *main-disp*)
  (format-display-fill demo-text-disp (format nil   "~%The goal of this program, specified in the
negative clause c28, is to find the path Path from a to g"))	  
  (when (wait)
  (my-software-push *proof-th-button* *main-disp*)
  (format-display-fill demo-text-disp (format nil  "~%Here is the complete proof"))
  (when (wait)
  (my-software-push *show-proof-button* *main-disp*)
  (format-display-fill demo-text-disp (format nil  "~%The button <Show Proof Tree> graphically displays
the proof tree of the last solution computed. 
Its shape  puts in evidence the linear-input, depth first 
search strategy used by Prolog.
" ))
  (when (wait)
  (my-software-push *show-proof-tree-button* *main-disp*)
    (setq *open-displays-list* (push  *browser-disp*  *open-displays-list* ))
  (format-display-fill demo-text-disp (format nil  "~%Pushing on the labels of the prof tree
you can see the correspondent formula. 
Press continue to close the browser.
"))
  (when (wait)
  (close-display *browser-disp*)  
  (format-display-fill demo-text-disp (format nil  "~%When a prolog theorem is loaded the user
can also interactively query the system, replacing the 
goal clause (in this case c28) with other queries.
To do so we must push the <Prolog Session> button"))
  (when (wait)
  (my-software-push *prolog-button* *main-disp*)
 (when (wait)
  (format-display-fill demo-text-disp (format nil  "~%Now we close the theorem proving tool~%"))
  (when (wait)
  (format-display-fill demo-text-disp (format nil  "~%******* End of the third DEMO ********"))
   (close-display *view*)
  (close-display *main-disp*)
  (close-display *out-disp* )
  (close-display *dialog-disp*)
  (sleep 3)))))))))))))))
  
    

;;; ========================================================


(defun read-query-from-window-demo-3()
  (disable-button demo-exit-button)
  (setf (title *dialog-disp*) "Prolog Interpreter: type in a query ('exit' to end)")
  (write-display *dialog-disp* " |? " 10 10) 
   (if (not *exit-user-query* )(progn(format-display-fill demo-text-disp (format nil  "~%Here is the current state of the database of clauses"))
     (my-software-push *list-db-button* *main-disp*)))
 
  
    (format-display-fill demo-text-disp (format nil  "~%Now the user types in a query"))
    (when (wait)
      
      
      (let* ((string   (if  *exit-user-query*  "exit" "door(a,X), door(X,c) , door(X,d)"))
	     (token-list (make-token-list string))
	     (goal-pair (goal  (cons '<=  token-list)))
	     (goal-fmla (car goal-pair)) (error (cdr  (cdr goal-pair)))
	     (neg-pos   (bipart-clause (car (clausify-main goal-fmla))))
	     (goal-clause  (renvar-for-internal (make-clause nil (car neg-pos))))
	     (answer-lit (cons '$ans  (collect-integer-vars 
				       (negative-atoms goal-clause)))))
	 (write-display *dialog-disp* string    60 10)
	 (if  *exit-user-query* 
	     (format-display-fill demo-text-disp (format nil  "~%The exit command ends the prolog listener"))
	   (format-display-fill demo-text-disp (format nil  "~%The prover adds this goal to the set of clauses
and starts proving this new theorem")))
	(when (wait)
	  (setq *exit-user-query* (not *exit-user-query*))
	 
	  (setq $user-vars$ (collect-vars goal-fmla))
	    (enable-button demo-exit-button)
	  (make-clause nil (append (negative-atoms goal-clause)
				   (list  answer-lit)))))))
  
  




(defun more-solutions-demo-3()
  (cond ((eq *right-solution* 0)
	 (setq *right-solution* 1)
	 (format-display-fill demo-text-disp (format nil 
			"~%The first solution is displayed in the Messages
display. As in Prolog systems you are allowed to ask for alternate 
solutions"))
	 (write-display *dialog-disp*  "Path = [a, b, c, e, g]" 10 10)
	 (when (wait)
	   nil))
	((eq *right-solution* 1)
	  (format-display-fill demo-text-disp (format nil 
			"~%The prolog interpreter displays the solution to the user's query
The next query will be the exit command"))
	  (clear-display *dialog-disp*)
	 (write-display *dialog-disp* " X = b" 10 10)
	  (when (wait)
	   nil))))
	 

(defun choose-file-demo-3 ()
  "atp-demo3.th")



(defun display-settings-demo-3 ()
   (protect-display set-disp  t)
  (format-display-fill demo-text-disp (format nil   "~%Now we change from Sequent format to Prolog ouput format
Notice that the Prolog strategy has been selected"))
  (when (wait) 
  (my-software-push *sequent-format-but* set-disp)  (sleep 0.5)
  (my-software-push *prolog-format-but* set-disp)
  (when (wait)
  (my-software-push *exit-disp-set-but* set-disp))))
  
