;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   en-strat.cl
;;; Short Desc: Main  ATP  algorithm 
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)



;;------------------------------------------------------------
;; en-strategy  : STRING --> {consistent, contradiction}
;; Behavior     : this is the main algorithm of en strategy: two
;;              : rules are choosen for superposition, the resulting
;;              : new rule (if any) is added to the the database, which,
;;              : if possible, is simplified. The loop ends either when
;;              : a contradiction is found or when no other rule can be
;;              : generated (the input axioms are consistent). 
;;              : In case of consistency the loop could never end.
;;              : "th-name" is the name of the file containing the theorem
;;              : the default directory is contained in *theorems-dir* 


(defun en-strategy (th-name)
  (setq *interface* nil)
  (catch 'syntax-error 
    (preproc1 th-name)
    (loop	  
      (if  (contradiction) 
	  (if  (more-solutions) 
	      (setq $contr$ nil)
	    (return 'contradiction)))
      (let* (( x-y (funcall (choose-clauses-function (eval $strategy$))))
	     ( x (car x-y))(y (cadr x-y)))
	(if (member nil x-y) (return 'consistent))
	(make-deductions x  y)))))


;;--------------------------------------------------------------------------
;;  more-solutions: {} -> {t,nil};
;;  Behavior     : Some operations  have to be done when
;;               : a contradiction is found: for instance, if
;;               : the answering mode were set on, the right answer
;;               : has to be printed out, and the user must be asked 
;;               : whether he wants alternative solutions

(defun  more-solutions ()
  (if $answering$ 
      (if *demo-in-execution*
	  (more-solutions-demo *demo-in-execution*)
	(if (not  *interface*)
	    (progn  (display-answers)
		    (print 'more?)
		    (eq 'y (read)))
	  (progn
	    (display-answers)
	    (equal 'Yes (my-y-or-n-dialog "More Solutions?" )))))))
 
;;------------------------------------------------------------------------
;; make-deductions : CLAUSE-ID x CLAUSE-ID ---> {nil}
;; Behavior     : Takes two clauses x and y and tries to deduce new clauses
;;              : The inference attempts are dependent on the class of clauses
;;              : as well as on some user definable flags.
;; Side effects : When a new clause is deduced is added to the 
;;              : database with a call to "store".

(defun make-deductions (x y) 
  (if (not (or $prolog-mode$ (eq x y)))
      (mk-deduct y (get-clause y) x (get-clause x)))
  (mk-deduct x (get-clause x) y (get-clause y)))


(defun active-clauses( x y)
  (and (or ( member x $simps$) (member x $rules$))
       (or ( member y $simps$) (member y $rules$))))
 



	
(defun contradiction	()
  $contr$)
  

(defun display-answers ()
  (let* ((stream (if *interface* (window *dialog-disp*) t ))
	(renamed-answer-clause  (renvar-for-out (eval $contr$)))
	(answerlist
	 (if (null (positive-atoms renamed-answer-clause))
	     (negative-atoms renamed-answer-clause)
	   (positive-atoms renamed-answer-clause))))
    (dolist (answer (butlast answerlist))
      (format-display stream "  Maybe ~%" )
      (format-display stream "~%~A"
		      (bindings-to-string 
		       (cdr answer) $user-answer-vars$))
      (format-display stream "  Or~%" ))
    (format-display stream "~%~A"
		    (bindings-to-string 
		     (cdar (last answerlist)) $user-answer-vars$))))
